/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class DumpGroovyControlFlowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        PsiFile psiFile = HandlerUtils.getPsiFile(editor, e.getDataContext());
        if (!(psiFile instanceof GroovyFile)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        List<GrControlFlowOwner> controlFlowOwners = DumpGroovyControlFlowAction.collectControlFlowOwners(psiFile, editor, offset);
        if (controlFlowOwners.isEmpty()) {
            return;
        }
        if (controlFlowOwners.size() == 1) {
            DumpGroovyControlFlowAction.passInner(controlFlowOwners.get(0));
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, controlFlowOwners, (Pass)new Pass<GrControlFlowOwner>(){

                public void pass(GrControlFlowOwner grExpression) {
                    DumpGroovyControlFlowAction.passInner(grExpression);
                }
            }, (Function)new Function<GrControlFlowOwner, String>(){

                public String fun(GrControlFlowOwner flowOwner) {
                    return flowOwner.getText();
                }
            });
        }
    }

    private static List<GrControlFlowOwner> collectControlFlowOwners(PsiFile file, Editor editor, int offset) {
        PsiElement elementAtCaret = file.findElementAt(offset);
        ArrayList<GrControlFlowOwner> result = new ArrayList<GrControlFlowOwner>();
        GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(elementAtCaret);
        while (owner != null && !result.contains(owner)) {
            result.add(owner);
            owner = ControlFlowUtils.findControlFlowOwner(owner);
        }
        return result;
    }

    private static void passInner(GrControlFlowOwner owner) {
        System.out.println(owner.getText());
        System.out.println(ControlFlowUtils.dumpControlFlow(owner.getControlFlow()));
    }
}

