/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.FileKeyDescriptor;
import org.jetbrains.jps.incremental.storage.Timestamps;

public class TimestampStorage
extends AbstractStateStorage<File, TimestampPerTarget[]>
implements Timestamps {
    private final BuildTargetsState myTargetsState;

    public TimestampStorage(File storePath, BuildTargetsState targetsState) throws IOException {
        super(storePath, new FileKeyDescriptor(), new StateExternalizer());
        this.myTargetsState = targetsState;
    }

    @Override
    public void force() {
        super.force();
    }

    @Override
    public void clean() throws IOException {
        super.clean();
    }

    @Override
    public long getStamp(File file, BuildTarget<?> target) throws IOException {
        TimestampPerTarget[] state = (TimestampPerTarget[])this.getState(file);
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(target);
            for (TimestampPerTarget timestampPerTarget : state) {
                if (timestampPerTarget.targetId != targetId) continue;
                return timestampPerTarget.timestamp;
            }
        }
        return -1L;
    }

    @Override
    public void saveStamp(File file, BuildTarget<?> buildTarget, long timestamp) throws IOException {
        int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
        this.update(file, TimestampStorage.updateTimestamp((TimestampPerTarget[])this.getState(file), targetId, timestamp));
    }

    private static TimestampPerTarget[] updateTimestamp(TimestampPerTarget[] oldState, int targetId, long timestamp) {
        TimestampPerTarget newItem = new TimestampPerTarget(targetId, timestamp);
        if (oldState == null) {
            return new TimestampPerTarget[]{newItem};
        }
        int length = oldState.length;
        for (int i = 0; i < length; ++i) {
            if (oldState[i].targetId != targetId) continue;
            oldState[i] = newItem;
            return oldState;
        }
        return (TimestampPerTarget[])ArrayUtil.append((Object[])oldState, (Object)newItem);
    }

    @Override
    public void removeStamp(File file, BuildTarget<?> buildTarget) throws IOException {
        Object[] state = (TimestampPerTarget[])this.getState(file);
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
            for (int i = 0; i < state.length; ++i) {
                TimestampPerTarget timestampPerTarget = state[i];
                if (timestampPerTarget.targetId != targetId) continue;
                if (state.length == 1) {
                    this.remove(file);
                    continue;
                }
                TimestampPerTarget[] newState = (TimestampPerTarget[])ArrayUtil.remove((Object[])state, (int)i);
                this.update(file, newState);
                break;
            }
        }
    }

    private static class StateExternalizer
    implements DataExternalizer<TimestampPerTarget[]> {
        private StateExternalizer() {
        }

        public void save(DataOutput out, TimestampPerTarget[] value) throws IOException {
            out.writeInt(value.length);
            for (TimestampPerTarget target : value) {
                out.writeInt(target.targetId);
                out.writeLong(target.timestamp);
            }
        }

        public TimestampPerTarget[] read(DataInput in) throws IOException {
            int size = in.readInt();
            TimestampPerTarget[] targets = new TimestampPerTarget[size];
            for (int i = 0; i < size; ++i) {
                int id = in.readInt();
                long timestamp = in.readLong();
                targets[i] = new TimestampPerTarget(id, timestamp);
            }
            return targets;
        }
    }

    public static class TimestampPerTarget {
        public final int targetId;
        public final long timestamp;

        public TimestampPerTarget(int targetId, long timestamp) {
            this.targetId = targetId;
            this.timestamp = timestamp;
        }
    }
}

