/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;

public class SourceToOutputMappingImpl
implements SourceToOutputMapping {
    private final OneToManyPathsMapping myMapping;

    public SourceToOutputMappingImpl(File storePath) throws IOException {
        this.myMapping = new OneToManyPathsMapping(storePath);
    }

    @Override
    public void setOutputs(String srcPath, Collection<String> outputs) throws IOException {
        this.myMapping.update(srcPath, outputs);
    }

    @Override
    public void setOutput(String srcPath, String outputPath) throws IOException {
        this.myMapping.update(srcPath, outputPath);
    }

    @Override
    public void appendOutput(String srcPath, String outputPath) throws IOException {
        this.myMapping.appendData(srcPath, outputPath);
    }

    @Override
    public void remove(String srcPath) throws IOException {
        this.myMapping.remove(srcPath);
    }

    @Override
    public void removeOutput(String sourcePath, String outputPath) throws IOException {
        this.myMapping.removeData(sourcePath, outputPath);
    }

    @Override
    public Collection<String> getSources() throws IOException {
        return this.myMapping.getKeys();
    }

    @Override
    public Collection<String> getOutputs(String srcPath) throws IOException {
        return this.myMapping.getState(srcPath);
    }

    @Override
    public Iterator<String> getSourcesIterator() throws IOException {
        return this.myMapping.getKeysIterator();
    }

    public void flush(boolean memoryCachesOnly) {
        this.myMapping.flush(memoryCachesOnly);
    }

    public void close() throws IOException {
        this.myMapping.close();
    }

    public void clean() throws IOException {
        this.myMapping.clean();
    }
}

