/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.org.objectweb.asm.ClassReader;

class OutputFilesSink
implements OutputFileConsumer {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.java.OutputFilesSink");
    private final CompileContext myContext;
    private final ModuleLevelBuilder.OutputConsumer myOutputConsumer;
    private final Callbacks.Backend myMappingsCallback;
    private final String myChunkName;
    private final Set<File> mySuccessfullyCompiled = new THashSet(FileUtil.FILE_HASHING_STRATEGY);

    public OutputFilesSink(CompileContext context, ModuleLevelBuilder.OutputConsumer outputConsumer, Callbacks.Backend callback, String chunkName) {
        this.myContext = context;
        this.myOutputConsumer = outputConsumer;
        this.myMappingsCallback = callback;
        this.myChunkName = "[" + chunkName + "]";
    }

    @Override
    public void save(OutputFileObject fileObject) {
        BinaryContent content = fileObject.getContent();
        File srcFile = fileObject.getSourceFile();
        boolean isTemp = false;
        JavaFileObject.Kind outKind = fileObject.getKind();
        if (srcFile != null && content != null) {
            String sourcePath = FileUtil.toSystemIndependentName((String)srcFile.getPath());
            JavaSourceRootDescriptor rootDescriptor = this.myContext.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(this.myContext, srcFile);
            if (rootDescriptor != null && !(isTemp = rootDescriptor.isTemp)) {
                try {
                    if (outKind == JavaFileObject.Kind.CLASS) {
                        this.myOutputConsumer.registerCompiledClass(rootDescriptor.target, new CompiledClass(fileObject.getFile(), srcFile, fileObject.getClassName(), content));
                    } else {
                        this.myOutputConsumer.registerOutputFile(rootDescriptor.target, fileObject.getFile(), Collections.singleton(sourcePath));
                    }
                }
                catch (IOException e) {
                    this.myContext.processMessage(new CompilerMessage("java", e));
                }
            }
            if (!isTemp && outKind == JavaFileObject.Kind.CLASS) {
                try {
                    FailSafeClassReader reader = new FailSafeClassReader(content.getBuffer(), content.getOffset(), content.getLength());
                    this.myMappingsCallback.associate(FileUtil.toSystemIndependentName((String)fileObject.getFile().getPath()), sourcePath, (ClassReader)reader);
                }
                catch (Throwable e) {
                    String message = "Class dependency information may be incomplete! Error parsing generated class " + fileObject.getFile().getPath();
                    LOG.info(message, e);
                    this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.WARNING, message + "\n" + CompilerMessage.getTextFromThrowable(e), sourcePath));
                }
            }
        }
        if (outKind == JavaFileObject.Kind.CLASS) {
            this.myContext.processMessage(new ProgressMessage("Writing classes... " + this.myChunkName));
            if (!isTemp && srcFile != null) {
                this.mySuccessfullyCompiled.add(srcFile);
            }
        }
    }

    public Set<File> getSuccessfullyCompiled() {
        return Collections.unmodifiableSet(this.mySuccessfullyCompiled);
    }

    public void markError(File sourceFile) {
        this.mySuccessfullyCompiled.remove(sourceFile);
    }

    public void markError(Set<File> problematic) {
        this.mySuccessfullyCompiled.removeAll(problematic);
    }
}

