/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.PersistentEnumeratorBase;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaBuilderExtension;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.ClassPostProcessor;
import org.jetbrains.jps.incremental.java.OutputFilesSink;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacServer;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.service.JpsServiceManager;

public class JavaBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.java.JavaBuilder");
    public static final String BUILDER_NAME = "java";
    private static final String JAVA_EXTENSION = "java";
    private static final String DOT_JAVA_EXTENSION = ".java";
    private static final Key<Integer> JAVA_COMPILER_VERSION_KEY = Key.create((String)"_java_compiler_version_");
    public static final Key<Boolean> IS_ENABLED = Key.create((String)"_java_compiler_enabled_");
    private static final Key<JavaCompilingTool> COMPILING_TOOL = Key.create((String)"_java_compiling_tool_");
    private static final Key<AtomicReference<String>> COMPILER_VERSION_INFO = Key.create((String)"_java_compiler_version_info_");
    private static final Set<String> FILTERED_OPTIONS = new HashSet<String>(Arrays.asList("-target"));
    private static final Set<String> FILTERED_SINGLE_OPTIONS = new HashSet<String>(Arrays.asList("-g", "-deprecation", "-nowarn", "-verbose", "-proc:none", "-proc:only", "-proceedOnError"));
    public static final FileFilter JAVA_SOURCES_FILTER = SystemInfo.isFileSystemCaseSensitive ? new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getPath().endsWith(JavaBuilder.DOT_JAVA_EXTENSION);
        }
    } : new FileFilter(){

        @Override
        public boolean accept(File file) {
            return StringUtil.endsWithIgnoreCase((String)file.getPath(), (String)JavaBuilder.DOT_JAVA_EXTENSION);
        }
    };
    private static final String RT_JAR_PATH_SUFFIX = File.separator + "rt.jar";
    private final Executor myTaskRunner;
    private static final List<ClassPostProcessor> ourClassProcessors = new ArrayList<ClassPostProcessor>();
    private static final Set<JpsModuleType<?>> ourCompilableModuleTypes = new HashSet();
    private static final File ourDefaultRtJar;
    private static final Key<List<String>> JAVAC_OPTIONS;
    private static final Key<List<String>> JAVAC_VM_OPTIONS;
    private static final Key<String> USER_DEFINED_BYTECODE_TARGET;
    private static final Key<TasksCounter> COUNTER_KEY;

    private static boolean isRtJarPath(String path) {
        if (StringUtil.endsWithIgnoreCase((String)path, (String)RT_JAR_PATH_SUFFIX)) {
            return true;
        }
        return RT_JAR_PATH_SUFFIX.charAt(0) != '/' && StringUtil.endsWithIgnoreCase((String)path, (String)"/rt.jar");
    }

    public static void registerClassPostProcessor(ClassPostProcessor processor) {
        ourClassProcessors.add(processor);
    }

    public JavaBuilder(Executor tasksExecutor) {
        super(BuilderCategory.TRANSLATOR);
        this.myTaskRunner = new SequentialTaskExecutor(tasksExecutor);
    }

    @Override
    public String getPresentableName() {
        return "java";
    }

    @Override
    public void buildStarted(CompileContext context) {
        String compilerId;
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
        String string = compilerId = config == null ? "Javac" : config.getJavaCompilerId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Java compiler ID: " + compilerId);
        }
        JavaCompilingTool compilingTool = JavaBuilderUtil.findCompilingTool(compilerId);
        COMPILING_TOOL.set((UserDataHolder)context, (Object)compilingTool);
        String messageText = compilingTool != null ? "Using " + compilingTool.getDescription() + " to compile java sources" : null;
        COMPILER_VERSION_INFO.set((UserDataHolder)context, new AtomicReference<Object>(messageText));
    }

    @Override
    public List<String> getCompilableFileExtensions() {
        return Collections.singletonList("java");
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        JavaCompilingTool compilingTool = (JavaCompilingTool)COMPILING_TOOL.get((UserDataHolder)context);
        if (!((Boolean)IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue() || compilingTool == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        return this.doBuild(context, chunk, dirtyFilesHolder, outputConsumer, compilingTool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleLevelBuilder.ExitCode doBuild(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer, JavaCompilingTool compilingTool) throws ProjectBuildException, IOException {
        try {
            ProjectBuilderLogger logger;
            THashSet filesToCompile = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            dirtyFilesHolder.processDirtyFiles(new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>((Set)filesToCompile){
                final /* synthetic */ Set val$filesToCompile;
                {
                    this.val$filesToCompile = set;
                }

                @Override
                public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor descriptor) throws IOException {
                    if (JAVA_SOURCES_FILTER.accept(file) && ourCompilableModuleTypes.contains(target.getModule().getModuleType())) {
                        this.val$filesToCompile.add(file);
                    }
                    return true;
                }
            });
            if (JavaBuilderUtil.isCompileJavaIncrementally(context) && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled() && filesToCompile.size() > 0) {
                logger.logCompiledFiles((Collection<File>)filesToCompile, "java", "Compiling files:");
            }
            return this.compile(context, chunk, dirtyFilesHolder, (Collection<File>)filesToCompile, outputConsumer, compilingTool);
        }
        catch (BuildDataCorruptedException e) {
            throw e;
        }
        catch (ProjectBuildException e) {
            throw e;
        }
        catch (PersistentEnumeratorBase.CorruptedException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            if (message == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream(out);
                try {
                    e.printStackTrace(stream);
                }
                finally {
                    stream.close();
                }
                message = "Internal error: \n" + out.toString();
            }
            context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, message));
            throw new StopBuildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleLevelBuilder.ExitCode compile(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, Collection<File> files, ModuleLevelBuilder.OutputConsumer outputConsumer, JavaCompilingTool compilingTool) throws Exception {
        ModuleLevelBuilder.ExitCode exitCode;
        block19: {
            boolean hasSourcesToCompile;
            exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            boolean bl = hasSourcesToCompile = !files.isEmpty();
            if (!hasSourcesToCompile && !dirtyFilesHolder.hasRemovedFiles()) {
                return exitCode;
            }
            ProjectDescriptor pd = context.getProjectDescriptor();
            JavaBuilderUtil.ensureModuleHasJdk(chunk.representativeTarget().getModule(), context, "java");
            Collection<File> classpath = ProjectPaths.getCompilationClasspath(chunk, false);
            Collection<File> platformCp = ProjectPaths.getPlatformCompilationClasspath(chunk, false);
            OutputFilesSink outputSink = new OutputFilesSink(context, outputConsumer, JavaBuilderUtil.getDependenciesRegistrar(context), chunk.getPresentableShortName());
            try {
                if (!hasSourcesToCompile) break block19;
                AtomicReference ref = (AtomicReference)COMPILER_VERSION_INFO.get((UserDataHolder)context);
                String versionInfo = ref.getAndSet(null);
                if (versionInfo != null) {
                    LOG.info(versionInfo);
                    context.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, versionInfo));
                }
                exitCode = ModuleLevelBuilder.ExitCode.OK;
                HashSet<File> srcPath = new HashSet<File>();
                BuildRootIndex index = pd.getBuildRootIndex();
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    for (JavaSourceRootDescriptor rd : index.getTempTargetRoots(target, context)) {
                        srcPath.add(rd.root);
                    }
                }
                DiagnosticSink diagnosticSink = new DiagnosticSink(context);
                String chunkName = chunk.getName();
                context.processMessage(new ProgressMessage("Parsing java... [" + chunk.getPresentableShortName() + "]"));
                int filesCount = files.size();
                boolean compiledOk = true;
                if (filesCount > 0) {
                    LOG.info("Compiling " + filesCount + " java files; module: " + chunkName + (chunk.containsTests() ? " (tests)" : ""));
                    if (LOG.isDebugEnabled()) {
                        for (File file : files) {
                            LOG.debug("Compiling " + file.getPath());
                        }
                        LOG.debug(" classpath for " + chunkName + ":");
                        for (File file : classpath) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                        LOG.debug(" platform classpath for " + chunkName + ":");
                        for (File file : platformCp) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                    }
                    try {
                        compiledOk = this.compileJava(context, chunk, files, classpath, platformCp, srcPath, diagnosticSink, outputSink, compilingTool);
                    }
                    finally {
                        for (File file : diagnosticSink.getFilesWithErrors()) {
                            if (file.exists()) continue;
                            FSOperations.markDeleted(context, file);
                        }
                    }
                }
                context.checkCanceled();
                if (!compiledOk && diagnosticSink.getErrorCount() == 0) {
                    diagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, "Compilation failed: internal java compiler error"));
                }
                if (!((Boolean)Utils.PROCEED_ON_ERROR_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE)).booleanValue() && diagnosticSink.getErrorCount() > 0) {
                    if (!compiledOk) {
                        diagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.OTHER, "Errors occurred while compiling module '" + chunkName + "'"));
                    }
                    throw new StopBuildException("Compilation failed: errors: " + diagnosticSink.getErrorCount() + "; warnings: " + diagnosticSink.getWarningCount());
                }
            }
            finally {
                JavaBuilderUtil.registerFilesToCompile(context, files);
                JavaBuilderUtil.registerSuccessfullyCompiled(context, outputSink.getSuccessfullyCompiled());
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileJava(CompileContext context, ModuleChunk chunk, Collection<File> files, Collection<File> classpath, Collection<File> platformCp, Collection<File> sourcePath, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool) throws Exception {
        TasksCounter counter = new TasksCounter();
        COUNTER_KEY.set((UserDataHolder)context, (Object)counter);
        JpsJavaExtensionService javaExt = JpsJavaExtensionService.getInstance();
        JpsJavaCompilerConfiguration compilerConfig = javaExt.getCompilerConfiguration(context.getProjectDescriptor().getProject());
        assert (compilerConfig != null);
        Set<JpsModule> modules = chunk.getModules();
        ProcessorConfigProfile profile = null;
        if (modules.size() == 1) {
            profile = compilerConfig.getAnnotationProcessingProfile(modules.iterator().next());
        } else {
            String message = JavaBuilder.validateCycle(chunk, javaExt, compilerConfig, modules);
            if (message != null) {
                diagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, message));
                return true;
            }
        }
        Map<File, Set<File>> outs = JavaBuilder.buildOutputDirectoriesMap(context, chunk);
        List<String> options = JavaBuilder.getCompilationOptions(context, chunk, profile, compilingTool);
        ClassProcessingConsumer classesConsumer = new ClassProcessingConsumer(context, outputSink);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Compiling chunk [" + chunk.getName() + "] with options: \"" + StringUtil.join(options, (String)" ") + "\"");
        }
        try {
            boolean rc;
            int chunkSdkVersion = JavaBuilder.getChunkSdkVersion(chunk);
            Collection<File> _platformCp = JavaBuilder.calcEffectivePlatformCp(platformCp, chunkSdkVersion, options, compilingTool);
            if (_platformCp == null) {
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, "Compact compilation profile was requested, but target platform for module \"" + chunk.getName() + "\" differs from javac's platform (" + System.getProperty("java.version") + ")\nCompilation profiles are not supported for such configuration"));
                boolean bl = true;
                return bl;
            }
            if (!JavaBuilder.shouldForkCompilerProcess(context, chunkSdkVersion)) {
                rc = JavacMain.compile(options, files, classpath, _platformCp, sourcePath, outs, diagnosticSink, classesConsumer, context.getCancelStatus(), compilingTool);
            } else {
                String sdkHome = JavaBuilder.getChunkSdkHome(chunk);
                if (sdkHome == null) {
                    diagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, "Cannot start javac process for " + chunk.getName() + ": unknown JDK home path.\nPlease check project configuration."));
                    boolean bl = true;
                    return bl;
                }
                List<String> vmOptions = JavaBuilder.getCompilationVMOptions(context, compilingTool);
                ExternalJavacServer server = JavaBuilder.ensureJavacServerStarted(context);
                rc = server.forkJavac(context, options, vmOptions, files, classpath, _platformCp, sourcePath, outs, diagnosticSink, classesConsumer, sdkHome, compilingTool);
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            counter.await();
        }
    }

    public static String validateCycle(ModuleChunk chunk, JpsJavaExtensionService javaExt, JpsJavaCompilerConfiguration compilerConfig, Set<JpsModule> modules) {
        Pair pair = null;
        for (JpsModule module : modules) {
            LanguageLevel moduleLevel = javaExt.getLanguageLevel(module);
            if (pair == null) {
                pair = Pair.create((Object)module.getName(), (Object)moduleLevel);
                continue;
            }
            if (Comparing.equal((Object)pair.getSecond(), (Object)moduleLevel)) continue;
            return "Modules " + (String)pair.getFirst() + " and " + module.getName() + " must have the same language level because of cyclic dependencies between them";
        }
        for (JpsModule module : modules) {
            ProcessorConfigProfile prof = compilerConfig.getAnnotationProcessingProfile(module);
            if (!prof.isEnabled()) continue;
            return "Annotation processing is not supported for module cycles. Please ensure that all modules from cycle [" + chunk.getName() + "] are excluded from annotation processing";
        }
        return null;
    }

    private static boolean shouldForkCompilerProcess(CompileContext context, int chunkSdkVersion) {
        int compilerSdkVersion = JavaBuilder.getCompilerSdkVersion(context);
        if (compilerSdkVersion < 9 || chunkSdkVersion < 0) {
            return false;
        }
        if (chunkSdkVersion >= 9 && compilerSdkVersion != chunkSdkVersion) {
            return true;
        }
        return Math.abs(compilerSdkVersion - chunkSdkVersion) > 3;
    }

    private static Collection<File> calcEffectivePlatformCp(Collection<File> platformCp, int chunkSdkVersion, List<String> options, JavaCompilingTool compilingTool) {
        if (chunkSdkVersion >= 9) {
            return Collections.emptyList();
        }
        if (ourDefaultRtJar == null || !(compilingTool instanceof JavacCompilerTool)) {
            return platformCp;
        }
        boolean profileFeatureRequested = false;
        for (String option : options) {
            if (!"-profile".equalsIgnoreCase(option)) continue;
            profileFeatureRequested = true;
            break;
        }
        if (!profileFeatureRequested) {
            return platformCp;
        }
        boolean isTargetPlatformSameAsBuildRuntime = false;
        for (File file : platformCp) {
            if (!FileUtil.filesEqual((File)file, (File)ourDefaultRtJar)) continue;
            isTargetPlatformSameAsBuildRuntime = true;
            break;
        }
        if (!isTargetPlatformSameAsBuildRuntime) {
            return null;
        }
        return Collections.emptyList();
    }

    private void submitAsyncTask(final CompileContext context, final Runnable taskRunnable) {
        final TasksCounter counter = (TasksCounter)COUNTER_KEY.get((UserDataHolder)context);
        assert (counter != null);
        counter.incTaskCount();
        this.myTaskRunner.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    taskRunnable.run();
                }
                catch (Throwable e) {
                    context.processMessage(new CompilerMessage("java", e));
                }
                finally {
                    counter.decTaskCounter();
                }
            }
        });
    }

    private static synchronized ExternalJavacServer ensureJavacServerStarted(CompileContext context) throws Exception {
        ExternalJavacServer server = (ExternalJavacServer)ExternalJavacServer.KEY.get(context);
        if (server != null) {
            return server;
        }
        int listenPort = JavaBuilder.findFreePort();
        server = new ExternalJavacServer();
        server.start(listenPort);
        ExternalJavacServer.KEY.set(context, server);
        return server;
    }

    private static int convertToNumber(String ver) {
        int quoteEnd;
        if (ver == null) {
            return 0;
        }
        int quoteBegin = ver.indexOf("\"");
        if (quoteBegin >= 0 && (quoteEnd = ver.indexOf("\"", quoteBegin + 1)) > quoteBegin) {
            ver = ver.substring(quoteBegin + 1, quoteEnd);
        }
        if (ver.isEmpty()) {
            return 0;
        }
        String prefix = "1.";
        int parseBegin = ver.startsWith("1.") ? "1.".length() : 0;
        int parseEnd = ver.indexOf(".", parseBegin);
        ver = parseEnd > 0 ? ver.substring(parseBegin, parseEnd) : ver.substring(parseBegin);
        try {
            return Integer.parseInt(ver);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket serverSocket;
        int n;
        ServerSocket serverSocket2 = new ServerSocket(0);
        try {
            n = serverSocket2.getLocalPort();
            serverSocket = serverSocket2;
        }
        catch (Throwable throwable) {
            try {
                ServerSocket serverSocket3 = serverSocket2;
                synchronized (serverSocket3) {
                    try {
                        serverSocket2.wait(1L);
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                }
                serverSocket2.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return 7878;
            }
        }
        synchronized (serverSocket) {
            try {
                serverSocket2.wait(1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        serverSocket2.close();
        return n;
    }

    private static List<String> getCompilationVMOptions(CompileContext context, JavaCompilingTool compilingTool) {
        List cached = (List)JAVAC_VM_OPTIONS.get((UserDataHolder)context);
        if (cached == null) {
            JavaBuilder.loadCommonJavacOptions(context, compilingTool);
            cached = (List)JAVAC_VM_OPTIONS.get((UserDataHolder)context);
        }
        return cached;
    }

    private static List<String> getCompilationOptions(CompileContext context, ModuleChunk chunk, ProcessorConfigProfile profile, JavaCompilingTool compilingTool) {
        List cached = (List)JAVAC_OPTIONS.get((UserDataHolder)context);
        if (cached == null) {
            JavaBuilder.loadCommonJavacOptions(context, compilingTool);
            cached = (List)JAVAC_OPTIONS.get((UserDataHolder)context);
            assert (cached != null) : context;
        }
        ArrayList<String> options = new ArrayList<String>();
        JpsModule module = chunk.representativeTarget().getModule();
        File baseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
        if (baseDirectory != null) {
            String stringToReplace = "$MODULE_DIR$";
            String moduleDirPath = FileUtil.toCanonicalPath((String)baseDirectory.getAbsolutePath());
            for (String s : cached) {
                options.add(StringUtil.replace((String)s, (String)stringToReplace, (String)moduleDirPath));
            }
        } else {
            options.addAll(cached);
        }
        JavaBuilder.addCompilationOptions(options, context, chunk, profile);
        return options;
    }

    public static void addCompilationOptions(List<String> options, CompileContext context, ModuleChunk chunk, ProcessorConfigProfile profile) {
        String langLevel;
        if (!JavaBuilder.isEncodingSet(options)) {
            CompilerEncodingConfiguration config = context.getProjectDescriptor().getEncodingConfiguration();
            String encoding = config.getPreferredModuleChunkEncoding(chunk);
            if (config.getAllModuleChunkEncodings(chunk).size() > 1) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("Multiple encodings set for module chunk ").append(chunk.getName());
                if (encoding != null) {
                    msgBuilder.append("\n\"").append(encoding).append("\" will be used by compiler");
                }
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.INFO, msgBuilder.toString()));
            }
            if (!StringUtil.isEmpty((String)encoding)) {
                options.add("-encoding");
                options.add(encoding);
            }
        }
        if (!StringUtil.isEmpty((String)(langLevel = JavaBuilder.getLanguageLevel(chunk.getModules().iterator().next())))) {
            options.add("-source");
            options.add(langLevel);
        }
        JpsJavaCompilerConfiguration compilerConfiguration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(context.getProjectDescriptor().getProject());
        String bytecodeTarget = null;
        for (JpsModule module : chunk.getModules()) {
            String moduleTarget = compilerConfiguration.getByteCodeTargetLevel(module.getName());
            if (moduleTarget == null) continue;
            if (bytecodeTarget == null) {
                bytecodeTarget = moduleTarget;
                continue;
            }
            if (moduleTarget.compareTo(bytecodeTarget) >= 0) continue;
            bytecodeTarget = moduleTarget;
        }
        if (bytecodeTarget == null) {
            bytecodeTarget = (String)USER_DEFINED_BYTECODE_TARGET.get((UserDataHolder)context);
        }
        int compilerSdkVersion = JavaBuilder.getCompilerSdkVersion(context);
        int chunkSdkVersion = JavaBuilder.getChunkSdkVersion(chunk);
        if (bytecodeTarget != null) {
            int userSpecifiedTargetVersion;
            options.add("-target");
            if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion && (userSpecifiedTargetVersion = JavaBuilder.convertToNumber(bytecodeTarget)) > 0 && userSpecifiedTargetVersion <= compilerSdkVersion && userSpecifiedTargetVersion > chunkSdkVersion) {
                bytecodeTarget = "1." + chunkSdkVersion;
            }
            options.add(bytecodeTarget);
        } else if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion) {
            options.add("-target");
            options.add("1." + chunkSdkVersion);
        }
        if (profile != null && profile.isEnabled()) {
            Set processors;
            if (!profile.isObtainProcessorsFromClasspath()) {
                String processorsPath = profile.getProcessorPath();
                options.add("-processorpath");
                options.add(processorsPath == null ? "" : FileUtil.toSystemDependentName((String)processorsPath.trim()));
            }
            if (!(processors = profile.getProcessors()).isEmpty()) {
                options.add("-processor");
                options.add(StringUtil.join((Collection)processors, (String)","));
            }
            for (Map.Entry optionEntry : profile.getProcessorOptions().entrySet()) {
                options.add("-A" + (String)optionEntry.getKey() + "=" + (String)optionEntry.getValue());
            }
            File srcOutput = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(chunk.getModules().iterator().next(), chunk.containsTests(), profile);
            if (srcOutput != null) {
                srcOutput.mkdirs();
                options.add("-s");
                options.add(srcOutput.getPath());
            }
        } else {
            options.add("-proc:none");
        }
    }

    private static String getLanguageLevel(JpsModule module) {
        LanguageLevel level = JpsJavaExtensionService.getInstance().getLanguageLevel(module);
        if (level != null) {
            switch (level) {
                case JDK_1_3: {
                    return "1.3";
                }
                case JDK_1_4: {
                    return "1.4";
                }
                case JDK_1_5: {
                    return "1.5";
                }
                case JDK_1_6: {
                    return "1.6";
                }
                case JDK_1_7: {
                    return "1.7";
                }
                case JDK_1_8: {
                    return "8";
                }
                case JDK_1_9: {
                    return "9";
                }
            }
        }
        return null;
    }

    private static boolean isEncodingSet(List<String> options) {
        for (String option : options) {
            if (!"-encoding".equals(option)) continue;
            return true;
        }
        return false;
    }

    private static int getCompilerSdkVersion(CompileContext context) {
        Integer cached = (Integer)JAVA_COMPILER_VERSION_KEY.get((UserDataHolder)context);
        if (cached != null) {
            return cached;
        }
        int javaVersion = JavaBuilder.convertToNumber(SystemProperties.getJavaVersion());
        JAVA_COMPILER_VERSION_KEY.set((UserDataHolder)context, (Object)javaVersion);
        return javaVersion;
    }

    private static int getChunkSdkVersion(ModuleChunk chunk) {
        int chunkSdkVersion = -1;
        for (JpsModule module : chunk.getModules()) {
            int moduleSdkVersion;
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            if (sdk == null || (moduleSdkVersion = JavaBuilder.convertToNumber(sdk.getVersionString())) == 0 || chunkSdkVersion >= 0 && chunkSdkVersion <= moduleSdkVersion) continue;
            chunkSdkVersion = moduleSdkVersion;
        }
        return chunkSdkVersion;
    }

    private static String getChunkSdkHome(ModuleChunk chunk) {
        for (JpsModule module : chunk.getModules()) {
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            if (sdk == null) continue;
            return sdk.getHomePath();
        }
        return null;
    }

    private static void loadCommonJavacOptions(CompileContext context, JavaCompilingTool compilingTool) {
        String customArgs;
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> vmOptions = new ArrayList<String>();
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        JpsJavaCompilerOptions compilerOptions = compilerConfig.getCurrentCompilerOptions();
        if (compilerOptions.DEBUGGING_INFO) {
            options.add("-g");
        }
        if (compilerOptions.DEPRECATION) {
            options.add("-deprecation");
        }
        if (compilerOptions.GENERATE_NO_WARNINGS) {
            options.add("-nowarn");
        }
        if (compilerOptions instanceof EclipseCompilerOptions) {
            EclipseCompilerOptions eclipseOptions = (EclipseCompilerOptions)compilerOptions;
            if (eclipseOptions.PROCEED_ON_ERROR) {
                options.add("-proceedOnError");
            }
        }
        if ((customArgs = compilerOptions.ADDITIONAL_OPTIONS_STRING) != null) {
            StringTokenizer customOptsTokenizer = new StringTokenizer(customArgs, " \t\r\n");
            boolean skip = false;
            boolean targetOptionFound = false;
            while (customOptsTokenizer.hasMoreTokens()) {
                String userOption = customOptsTokenizer.nextToken();
                if (FILTERED_OPTIONS.contains(userOption)) {
                    skip = true;
                    targetOptionFound = "-target".equals(userOption);
                    continue;
                }
                if (skip) {
                    skip = false;
                    if (!targetOptionFound) continue;
                    targetOptionFound = false;
                    USER_DEFINED_BYTECODE_TARGET.set((UserDataHolder)context, (Object)userOption);
                    continue;
                }
                if (FILTERED_SINGLE_OPTIONS.contains(userOption)) continue;
                if (userOption.startsWith("-J-")) {
                    vmOptions.add(userOption.substring("-J".length()));
                    continue;
                }
                options.add(userOption);
            }
        }
        compilingTool.processCompilerOptions(context, options);
        JAVAC_OPTIONS.set((UserDataHolder)context, options);
        JAVAC_VM_OPTIONS.set((UserDataHolder)context, vmOptions);
    }

    @Override
    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        JavaBuilderUtil.cleanupChunkResources(context);
    }

    private static Map<File, Set<File>> buildOutputDirectoriesMap(CompileContext context, ModuleChunk chunk) {
        THashMap map = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File outputDir = target.getOutputDir();
            if (outputDir == null) continue;
            THashSet roots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (JavaSourceRootDescriptor descriptor : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots(target, context)) {
                roots.add(descriptor.root);
            }
            map.put(outputDir, roots);
        }
        return map;
    }

    static {
        for (JavaBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(JavaBuilderExtension.class)) {
            ourCompilableModuleTypes.addAll(extension.getCompilableModuleTypes());
        }
        File rtJar = null;
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("sun.boot.class.path", ""), File.pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            if (!JavaBuilder.isRtJarPath(path)) continue;
            rtJar = new File(path);
            break;
        }
        ourDefaultRtJar = rtJar;
        JAVAC_OPTIONS = Key.create((String)"_javac_options_");
        JAVAC_VM_OPTIONS = Key.create((String)"_javac_vm_options_");
        USER_DEFINED_BYTECODE_TARGET = Key.create((String)"_user_defined_bytecode_target_");
        COUNTER_KEY = Key.create((String)"_async_task_counter_");
    }

    private static final class TasksCounter {
        private int myCounter = 0;

        private TasksCounter() {
        }

        public synchronized void incTaskCount() {
            ++this.myCounter;
        }

        public synchronized void decTaskCounter() {
            this.myCounter = Math.max(0, this.myCounter - 1);
            if (this.myCounter == 0) {
                this.notifyAll();
            }
        }

        public synchronized void await() {
            while (this.myCounter > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ClassProcessingConsumer
    implements OutputFileConsumer {
        private final CompileContext myContext;
        private final OutputFileConsumer myDelegateOutputFileSink;

        public ClassProcessingConsumer(CompileContext context, OutputFileConsumer sink) {
            this.myContext = context;
            this.myDelegateOutputFileSink = sink != null ? sink : new OutputFileConsumer(){

                @Override
                public void save(OutputFileObject fileObject) {
                    throw new RuntimeException("Output sink for compiler was not specified");
                }
            };
        }

        @Override
        public void save(final OutputFileObject fileObject) {
            try {
                BinaryContent content = fileObject.getContent();
                File file = fileObject.getFile();
                if (content != null) {
                    content.saveToFile(file);
                } else {
                    this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.WARNING, "Missing content for file " + file.getPath()));
                }
            }
            catch (IOException e) {
                this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, e.getMessage()));
            }
            JavaBuilder.this.submitAsyncTask(this.myContext, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (ClassPostProcessor processor : ourClassProcessors) {
                            processor.process(ClassProcessingConsumer.this.myContext, fileObject);
                        }
                    }
                    finally {
                        ClassProcessingConsumer.this.myDelegateOutputFileSink.save(fileObject);
                    }
                }
            });
        }
    }

    private static class DiagnosticSink
    implements DiagnosticOutputConsumer {
        private final CompileContext myContext;
        private volatile int myErrorCount = 0;
        private volatile int myWarningCount = 0;
        private final Set<File> myFilesWithErrors = new HashSet<File>();

        public DiagnosticSink(CompileContext context) {
            this.myContext = context;
        }

        @Override
        public void javaFileLoaded(File file) {
        }

        @Override
        public void registerImports(String className, Collection<String> imports, Collection<String> staticImports) {
        }

        @Override
        public void outputLineAvailable(String line) {
            if (!StringUtil.isEmpty((String)line)) {
                if (line.contains("java.lang.OutOfMemoryError")) {
                    this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, "OutOfMemoryError: insufficient memory"));
                    ++this.myErrorCount;
                } else {
                    BuildMessage.Kind kind = DiagnosticSink.getKindByMessageText(line);
                    if (kind == BuildMessage.Kind.ERROR) {
                        ++this.myErrorCount;
                    } else if (kind == BuildMessage.Kind.WARNING) {
                        ++this.myWarningCount;
                    }
                    this.myContext.processMessage(new CompilerMessage("java", kind, line));
                }
            }
        }

        private static BuildMessage.Kind getKindByMessageText(String line) {
            String lowercasedLine = line.toLowerCase(Locale.US);
            if (lowercasedLine.contains("error") || lowercasedLine.contains("requires target release")) {
                return BuildMessage.Kind.ERROR;
            }
            return BuildMessage.Kind.INFO;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            String srcPath;
            BuildMessage.Kind kind;
            switch (diagnostic.getKind()) {
                case ERROR: {
                    kind = BuildMessage.Kind.ERROR;
                    ++this.myErrorCount;
                    break;
                }
                case MANDATORY_WARNING: 
                case WARNING: {
                    kind = BuildMessage.Kind.WARNING;
                    ++this.myWarningCount;
                    break;
                }
                default: {
                    kind = BuildMessage.Kind.INFO;
                }
            }
            File sourceFile = null;
            try {
                JavaFileObject source = diagnostic.getSource();
                sourceFile = source != null ? Utils.convertToFile(source.toUri()) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
            if (sourceFile != null) {
                this.myFilesWithErrors.add(sourceFile);
                srcPath = FileUtil.toSystemIndependentName((String)sourceFile.getPath());
            } else {
                srcPath = null;
            }
            String message = diagnostic.getMessage(Locale.US);
            if (Utils.IS_TEST_MODE) {
                LOG.info(message);
            }
            this.myContext.processMessage(new CompilerMessage("java", kind, message, srcPath, diagnostic.getStartPosition(), diagnostic.getEndPosition(), diagnostic.getPosition(), diagnostic.getLineNumber(), diagnostic.getColumnNumber()));
        }

        public int getErrorCount() {
            return this.myErrorCount;
        }

        public int getWarningCount() {
            return this.myWarningCount;
        }

        public Collection<File> getFilesWithErrors() {
            return this.myFilesWithErrors;
        }
    }
}

