/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;

public class FileBasedArtifactRootDescriptor
extends ArtifactRootDescriptor {
    private static final Logger LOG = Logger.getInstance(FileBasedArtifactRootDescriptor.class);
    private FileCopyingHandler myCopyingHandler;

    public FileBasedArtifactRootDescriptor(File file, SourceFileFilter filter, int index, ArtifactBuildTarget target, DestinationInfo destinationInfo, FileCopyingHandler copyingHandler) {
        super(file, FileBasedArtifactRootDescriptor.createCompositeFilter(filter, copyingHandler.createFileFilter()), index, target, destinationInfo);
        this.myCopyingHandler = copyingHandler;
    }

    private static SourceFileFilter createCompositeFilter(SourceFileFilter baseFilter, FileFilter filter) {
        if (filter.equals(FileUtilRt.ALL_FILES)) {
            return baseFilter;
        }
        return new CompositeSourceFileFilter(baseFilter, filter);
    }

    @Override
    protected String getFullPath() {
        return this.myRoot.getPath();
    }

    @Override
    public void writeConfiguration(PrintWriter out) {
        super.writeConfiguration(out);
        this.myCopyingHandler.writeConfiguration(out);
    }

    @Override
    public void copyFromRoot(String filePath, int rootIndex, String outputPath, CompileContext context, BuildOutputConsumer outputConsumer, ArtifactOutputToSourceMapping outSrcMapping) throws IOException, ProjectBuildException {
        String targetPath;
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        if (!FileUtil.filesEqual((File)file, (File)this.getRootFile())) {
            String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)this.getRootFile().getPath()), (String)filePath, (char)'/');
            if (relativePath == null || relativePath.startsWith("..")) {
                throw new ProjectBuildException((Throwable)((Object)new AssertionError((Object)(filePath + " is not under " + this.getRootFile().getPath()))));
            }
            targetPath = JpsArtifactPathUtil.appendToPath(outputPath, relativePath);
        } else {
            targetPath = outputPath;
        }
        File targetFile = new File(targetPath);
        if (FileUtil.filesEqual((File)file, (File)targetFile)) {
            return;
        }
        if (outSrcMapping.getState(targetPath) == null) {
            ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
            if (logger.isEnabled()) {
                logger.logCompiledFiles(Collections.singletonList(file), "Artifacts builder", "Copying file:");
            }
            this.myCopyingHandler.copyFile(file, targetFile, context);
            outputConsumer.registerOutputFile(targetFile, Collections.singletonList(filePath));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Target path " + targetPath + " is already registered so " + filePath + " won't be copied");
        }
        outSrcMapping.appendData(targetPath, rootIndex, filePath);
    }

    private static class CompositeSourceFileFilter
    extends SourceFileFilter {
        private final SourceFileFilter myBaseFilter;
        private final FileFilter myFilter;

        public CompositeSourceFileFilter(SourceFileFilter baseFilter, FileFilter filter) {
            this.myBaseFilter = baseFilter;
            this.myFilter = filter;
        }

        @Override
        public boolean accept(String fullFilePath) {
            return this.myFilter.accept(new File(fullFilePath)) && this.myBaseFilter.accept(fullFilePath);
        }

        @Override
        public boolean shouldBeCopied(String fullFilePath, ProjectDescriptor projectDescriptor) throws IOException {
            return this.myBaseFilter.shouldBeCopied(fullFilePath, projectDescriptor);
        }
    }
}

