/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;
import org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuildersRegistry;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContext;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContextImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.CopyToDirectoryInstructionCreator;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class ArtifactBuildTarget
extends BuildTarget<ArtifactRootDescriptor> {
    private final JpsArtifact myArtifact;

    public ArtifactBuildTarget(JpsArtifact artifact) {
        super(ArtifactBuildTargetType.INSTANCE);
        this.myArtifact = artifact;
    }

    @Override
    public String getId() {
        return this.myArtifact.getName();
    }

    public JpsArtifact getArtifact() {
        return this.myArtifact;
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, final TargetOutputIndex outputIndex) {
        final LinkedHashSet dependencies = new LinkedHashSet();
        JpsArtifactUtil.processPackagingElements((JpsPackagingElement)this.myArtifact.getRootElement(), new Processor<JpsPackagingElement>(){

            public boolean process(JpsPackagingElement element) {
                JpsArtifact included;
                if (element instanceof JpsArtifactOutputPackagingElement && (included = (JpsArtifact)((JpsArtifactOutputPackagingElement)element).getArtifactReference().resolve()) != null && !included.equals(ArtifactBuildTarget.this.myArtifact) && !StringUtil.isEmpty((String)included.getOutputPath())) {
                    dependencies.add(new ArtifactBuildTarget(included));
                    return false;
                }
                dependencies.addAll(LayoutElementBuildersRegistry.getInstance().getDependencies(element, outputIndex));
                return true;
            }
        });
        if (!dependencies.isEmpty()) {
            SmartList additional = new SmartList();
            for (BuildTarget buildTarget : dependencies) {
                if (!(buildTarget instanceof ModuleBasedTarget)) continue;
                ModuleBasedTarget target = (ModuleBasedTarget)buildTarget;
                additional.addAll(targetRegistry.getModuleBasedTargets(target.getModule(), target.isTests() ? BuildTargetRegistry.ModuleTargetSelector.TEST : BuildTargetRegistry.ModuleTargetSelector.PRODUCTION));
            }
            dependencies.addAll((Collection<BuildTarget<?>>)additional);
        }
        return dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myArtifact.equals(((ArtifactBuildTarget)o).myArtifact);
    }

    public int hashCode() {
        return this.myArtifact.hashCode();
    }

    @Override
    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        out.println(StringUtil.notNullize((String)this.myArtifact.getOutputPath()));
        BuildRootIndex rootIndex = pd.getBuildRootIndex();
        for (ArtifactRootDescriptor descriptor : rootIndex.getTargetRoots(this, null)) {
            descriptor.writeConfiguration(out);
        }
    }

    @Override
    public List<ArtifactRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArtifactInstructionsBuilderImpl builder = new ArtifactInstructionsBuilderImpl(index, ignoredFileIndex, this, model, dataPaths);
        ArtifactInstructionsBuilderContextImpl context = new ArtifactInstructionsBuilderContextImpl(model, dataPaths);
        String outputPath = StringUtil.notNullize((String)this.myArtifact.getOutputPath());
        CopyToDirectoryInstructionCreator instructionCreator = new CopyToDirectoryInstructionCreator(builder, outputPath);
        LayoutElementBuildersRegistry.getInstance().generateInstructions(this.myArtifact, instructionCreator, (ArtifactInstructionsBuilderContext)context);
        return builder.getDescriptors();
    }

    @Override
    public ArtifactRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        return rootIndex.getTargetRoots(this, null).get(Integer.valueOf(rootId));
    }

    @Override
    public String getPresentableName() {
        return "Artifact '" + this.myArtifact.getName() + "'";
    }

    @Override
    public Collection<File> getOutputRoots(CompileContext context) {
        String outputFilePath = this.myArtifact.getOutputFilePath();
        return outputFilePath != null && !StringUtil.isEmpty((String)outputFilePath) ? Collections.singleton(new File(FileUtil.toSystemDependentName((String)outputFilePath))) : Collections.emptyList();
    }
}

