/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.JVMModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.JpsPathUtil;

public final class ModuleBuildTarget
extends JVMModuleBuildTarget<JavaSourceRootDescriptor> {
    public static final Boolean REBUILD_ON_DEPENDENCY_CHANGE = Boolean.valueOf(System.getProperty("rebuild.on.dependency.change", "true"));
    private final JavaModuleBuildTargetType myTargetType;

    public ModuleBuildTarget(JpsModule module, JavaModuleBuildTargetType targetType) {
        super(targetType, module);
        this.myTargetType = targetType;
    }

    public File getOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.myTargetType.isTests());
    }

    @Override
    public Collection<File> getOutputRoots(CompileContext context) {
        File annotationOut;
        SmartList result = new SmartList();
        File outputDir = this.getOutputDir();
        if (outputDir != null) {
            result.add(outputDir);
        }
        JpsModule module = this.getModule();
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(module.getProject());
        ProcessorConfigProfile profile = configuration.getAnnotationProcessingProfile(module);
        if (profile.isEnabled() && (annotationOut = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(module, this.isTests(), profile)) != null) {
            result.add(annotationOut);
        }
        return result;
    }

    @Override
    public boolean isTests() {
        return this.myTargetType.isTests();
    }

    @Override
    public final boolean isCompiledBeforeModuleLevelBuilders() {
        return false;
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)this.myModule).compileOnly();
        if (!this.isTests()) {
            enumerator.productionOnly();
        }
        final ArrayList dependencies = new ArrayList();
        enumerator.processModules((Consumer)new Consumer<JpsModule>(){

            public void consume(JpsModule module) {
                dependencies.add(new ModuleBuildTarget(module, ModuleBuildTarget.this.myTargetType));
            }
        });
        if (this.isTests()) {
            dependencies.add(new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION));
        }
        Collection<ModuleBasedTarget<?>> moduleBased = targetRegistry.getModuleBasedTargets(this.getModule(), this.isTests() ? BuildTargetRegistry.ModuleTargetSelector.TEST : BuildTargetRegistry.ModuleTargetSelector.PRODUCTION);
        for (ModuleBasedTarget<?> target : moduleBased) {
            if (target == this || !target.isCompiledBeforeModuleLevelBuilders()) continue;
            dependencies.add(target);
        }
        dependencies.trimToSize();
        return dependencies;
    }

    @Override
    public List<JavaSourceRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<JavaSourceRootDescriptor> roots = new ArrayList<JavaSourceRootDescriptor>();
        JavaSourceRootType type = this.isTests() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        Iterable excludedRootProviders = JpsServiceManager.getInstance().getExtensions(ExcludedJavaSourceRootProvider.class);
        THashSet moduleExcludes = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        moduleExcludes.addAll(index.getModuleExcludes(this.myModule));
        block0: for (JpsTypedModuleSourceRoot sourceRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)type)) {
            if (JpsPathUtil.isUnder((Set)moduleExcludes, (File)sourceRoot.getFile())) continue;
            for (ExcludedJavaSourceRootProvider provider : excludedRootProviders) {
                if (!provider.isExcludedFromCompilation(this.myModule, (JpsModuleSourceRoot)sourceRoot)) continue;
                continue block0;
            }
            String packagePrefix = ((JavaSourceRootProperties)sourceRoot.getProperties()).getPackagePrefix();
            roots.add(new JavaSourceRootDescriptor(sourceRoot.getFile(), this, false, false, packagePrefix, this.computeRootExcludes(sourceRoot.getFile(), index)));
        }
        return roots;
    }

    @Override
    public String getPresentableName() {
        return "Module '" + this.getModule().getName() + "' " + (this.myTargetType.isTests() ? "tests" : "production");
    }

    @Override
    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        CompilerEncodingConfiguration encodingConfig;
        String encoding;
        JpsJavaCompilerConfiguration config;
        String bytecodeTarget;
        JpsModule module = this.getModule();
        int fingerprint = this.getDependenciesFingerprint();
        for (JavaSourceRootDescriptor root : pd.getBuildRootIndex().getTargetRoots(this, null)) {
            fingerprint += FileUtil.fileHashCode((File)root.getRootFile());
        }
        LanguageLevel level = JpsJavaExtensionService.getInstance().getLanguageLevel(module);
        if (level != null) {
            fingerprint += level.name().hashCode();
        }
        if ((bytecodeTarget = (config = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(module.getProject())).getByteCodeTargetLevel(module.getName())) != null) {
            fingerprint += bytecodeTarget.hashCode();
        }
        if ((encoding = (encodingConfig = pd.getEncodingConfiguration()).getPreferredModuleEncoding(module)) != null) {
            fingerprint += encoding.hashCode();
        }
        out.write(Integer.toHexString(fingerprint));
    }

    private int getDependenciesFingerprint() {
        int fingerprint = 0;
        if (!REBUILD_ON_DEPENDENCY_CHANGE.booleanValue()) {
            return fingerprint;
        }
        JpsModule module = this.getModule();
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).compileOnly();
        if (!this.isTests()) {
            enumerator = enumerator.productionOnly();
        }
        for (String url : enumerator.classes().getUrls()) {
            fingerprint = 31 * fingerprint + url.hashCode();
        }
        return fingerprint;
    }
}

