/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.incremental.BinaryContent;

public class CompiledClass
extends UserDataHolderBase {
    private final File myOutputFile;
    private final File mySourceFile;
    private final String myClassName;
    private BinaryContent myContent;
    private boolean myIsDirty = false;

    public CompiledClass(File outputFile, File sourceFile, String className, BinaryContent content) {
        this.myOutputFile = outputFile;
        this.mySourceFile = sourceFile;
        this.myClassName = className;
        this.myContent = content;
    }

    public void save() throws IOException {
        this.myContent.saveToFile(this.myOutputFile);
        this.myIsDirty = false;
    }

    public File getOutputFile() {
        return this.myOutputFile;
    }

    public File getSourceFile() {
        return this.mySourceFile;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public BinaryContent getContent() {
        return this.myContent;
    }

    public void setContent(BinaryContent content) {
        this.myContent = content;
        this.myIsDirty = true;
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CompiledClass aClass = (CompiledClass)((Object)o);
        return FileUtil.filesEqual((File)this.myOutputFile, (File)aClass.myOutputFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myOutputFile);
    }
}

