/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestingBaseColumn;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColoredRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class GoogleCloudTestingColumnDuration
extends GoogleCloudTestingBaseColumn
implements Comparator<GoogleCloudTestProxy> {
    public GoogleCloudTestingColumnDuration() {
        super(SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tabs.statistics.columns.duration.title", (Object[])new Object[0]));
    }

    public String valueOf(GoogleCloudTestProxy testProxy) {
        return GoogleCloudTestsPresentationUtil.getDurationPresentation(testProxy);
    }

    public Comparator<GoogleCloudTestProxy> getComparator() {
        return this;
    }

    @Override
    public int compare(GoogleCloudTestProxy proxy1, GoogleCloudTestProxy proxy2) {
        Long duration1 = proxy1.getDuration();
        Long duration2 = proxy2.getDuration();
        if (duration1 == null) {
            return duration2 == null ? 0 : -1;
        }
        if (duration2 == null) {
            return 1;
        }
        return duration1.compareTo(duration2);
    }

    public TableCellRenderer getRenderer(GoogleCloudTestProxy proxy) {
        return new DurationCellRenderer();
    }

    public static class DurationCellRenderer
    extends ColoredTableCellRenderer
    implements ColoredRenderer {
        public void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            assert (value != null);
            this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

