/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.testIntegration.TestLocationProvider;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Set;

public class GoogleCloudTestingBasedToSMTRunnerEventsConvertor
extends GoogleCloudTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestingBasedToSMTRunnerEventsConvertor.class.getName());
    private final TIntObjectHashMap<Node> myNodeByIdMap = new TIntObjectHashMap();
    private final Set<Node> myRunningTestNodes = ContainerUtil.newHashSet();
    private final List<GoogleCloudTestEventsListener> myEventsListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final GoogleCloudTestProxy.GoogleCloudRootTestProxy myTestsRootProxy;
    private final Node myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished = false;
    private TestLocationProvider myLocator = null;
    private TestProxyPrinterProvider myTestProxyPrinterProvider = null;

    public GoogleCloudTestingBasedToSMTRunnerEventsConvertor(GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRootProxy, String testFrameworkName) {
        this.myTestsRootProxy = testsRootProxy;
        this.myTestsRootNode = new Node(0, null, testsRootProxy);
        this.myTestFrameworkName = testFrameworkName;
        this.myNodeByIdMap.put(this.myTestsRootNode.getId(), (Object)this.myTestsRootNode);
    }

    @Override
    public void setLocator(TestLocationProvider customLocator) {
        this.myLocator = customLocator;
    }

    @Override
    public void addEventsListener(GoogleCloudTestEventsListener listener) {
        this.myEventsListeners.add(listener);
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootNode.setState(State.RUNNING);
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setStarted();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestingStarted(true);
            }
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setTestsReporterAttached();
            }
        });
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                boolean completeTree = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.isTreeComplete();
                if (completeTree) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setFinished();
                } else {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setTerminated();
                }
                if (!GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty()) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Unexpected running nodes: " + GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes);
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestingFinished();
            }
        });
    }

    private boolean isTreeComplete() {
        if (!this.myRunningTestNodes.isEmpty()) {
            return false;
        }
        List<? extends GoogleCloudTestProxy> children = this.myTestsRootProxy.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.isFinal() && !googleCloudTestProxy.wasTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setPrinterProvider(TestProxyPrinterProvider printerProvider) {
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(final GoogleCloudTestStartedEvent testStartedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.doStartNode(testStartedEvent, false);
            }
        });
    }

    @Override
    public void onSuiteStarted(final TestSuiteStartedEvent suiteStartedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.doStartNode((BaseStartedNodeEvent)suiteStartedEvent, true);
            }
        });
    }

    private void doStartNode(BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        Node node = this.findNode((TreeNodeEvent)startedNodeEvent);
        if (node != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        Node parentNode = this.findValidParentNode(startedNodeEvent);
        if (parentNode == null) {
            return;
        }
        if (!this.validateNodeId((TreeNodeEvent)startedNodeEvent)) {
            return;
        }
        String nodeName = startedNodeEvent.getName();
        GoogleCloudTestProxy childProxy = new GoogleCloudTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), true);
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        node = new Node(startedNodeEvent.getId(), parentNode, childProxy);
        this.myNodeByIdMap.put(startedNodeEvent.getId(), (Object)node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    private Node findValidParentNode(BaseStartedNodeEvent startedNodeEvent) {
        int parentId = startedNodeEvent.getParentId();
        if (parentId < 0) {
            this.logProblem("Parent node id should be non-negative: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = (Node)this.myNodeByIdMap.get(startedNodeEvent.getParentId());
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(final GoogleCloudTestFinishedEvent testFinishedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)testFinishedEvent);
                if (node != null) {
                    GoogleCloudTestProxy testProxy = node.getProxy();
                    testProxy.setDuration(testFinishedEvent.getDuration());
                    testProxy.setFinished();
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Override
    public void onSuiteFinished(final TestSuiteFinishedEvent suiteFinishedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)suiteFinishedEvent);
                if (node != null) {
                    GoogleCloudTestProxy suiteProxy = node.getProxy();
                    suiteProxy.setFinished();
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnSuiteFinished(suiteProxy);
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Override
    public void onSetTestRunId(SetTestRunIdEvent setTestRunIdEvent) {
    }

    @Override
    public void onSetActiveCloudMatrix(SetActiveCloudMatrixEvent setActiveCloudMatrixEvent) {
    }

    @Override
    public void onConfigurationStarted(TestConfigurationStartedEvent configurationStartedEvent) {
    }

    @Override
    public void onConfigurationProgress(TestConfigurationProgressEvent configurationProgressEvent) {
    }

    @Override
    public void onConfigurationScheduled(TestConfigurationScheduledEvent configurationScheduledEvent) {
    }

    @Override
    public void onConfigurationStopped(TestConfigurationStoppedEvent configurationStoppedEvent) {
    }

    @Override
    public void onConfigurationFinished(TestConfigurationFinishedEvent configurationFinishedEvent) {
    }

    private Node findNodeToTerminate(TreeNodeEvent treeNodeEvent) {
        Node node = this.findNode(treeNodeEvent);
        if (node == null) {
            this.logProblem("Trying to finish not existent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(final String text, final Key outputType) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                GoogleCloudTestProxy activeProxy = activeNode.getProxy();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    activeProxy.addStdErr(text, true);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    activeProxy.addSystemOutput(text);
                } else {
                    activeProxy.addStdOutput(text, outputType, true);
                }
            }
        });
    }

    @Override
    public void onError(final String localizedMessage, final String stackTrace, final boolean isCritical) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                GoogleCloudTestProxy activeProxy = activeNode.getProxy();
                activeProxy.addError(localizedMessage, stackTrace, isCritical);
            }
        });
    }

    @Override
    public void onCustomProgressTestsCategory(final String categoryName, final int testCount) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestStarted();
            }
        });
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestFailed();
            }
        });
    }

    @Override
    public void onTestFailure(final GoogleCloudTestFailedEvent testFailedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)testFailedEvent);
                if (node == null) {
                    return;
                }
                GoogleCloudTestProxy testProxy = node.getProxy();
                String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
                String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
                String failureMessage = testFailedEvent.getLocalizedFailureMessage();
                String stackTrace = testFailedEvent.getStacktrace();
                if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                    testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText);
                } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                    testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
                } else {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\n" + "Actual:\n" + comparisonFailureActualText);
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FAILED);
            }
        });
    }

    @Override
    public void onTestIgnored(final GoogleCloudTestIgnoredEvent testIgnoredEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)testIgnoredEvent);
                if (node != null) {
                    GoogleCloudTestProxy testProxy = node.getProxy();
                    testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.IGNORED);
                }
            }
        });
    }

    @Override
    public void onTestOutput(final GoogleCloudTestOutputEvent testOutputEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNode((TreeNodeEvent)testOutputEvent);
                if (node == null) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! But " + (Object)((Object)testOutputEvent) + "!");
                    return;
                }
                GoogleCloudTestProxy testProxy = node.getProxy();
                if (testOutputEvent.isStdOut()) {
                    testProxy.addStdOutput(testOutputEvent.getText(), ProcessOutputTypes.STDOUT, true);
                } else {
                    testProxy.addStdErr(testOutputEvent.getText(), true);
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    private boolean validateNodeId(TreeNodeEvent treeNodeEvent) {
        int nodeId = treeNodeEvent.getId();
        if (nodeId <= 0) {
            this.logProblem("Node id should be positive: " + treeNodeEvent + ".", true);
            return false;
        }
        return true;
    }

    private Node findNode(TreeNodeEvent treeNodeEvent) {
        if (!this.validateNodeId(treeNodeEvent)) {
            return null;
        }
        return (Node)this.myNodeByIdMap.get(treeNodeEvent.getId());
    }

    private void fireOnTestingStarted(boolean printTestingStartedTime) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingStarted(this.myTestsRootProxy, printTestingStartedTime);
        }
    }

    private void fireOnTestingFinished() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingFinished(this.myTestsRootProxy);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestsCountInSuite(count);
        }
    }

    private void fireOnTestStarted(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestStarted(test);
        }
    }

    private void fireOnTestFinished(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFinished(test);
        }
    }

    private void fireOnTestFailed(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFailed(test);
        }
    }

    private void fireOnTestIgnored(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestIgnored(test);
        }
    }

    private void fireOnSuiteStarted(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteStarted(suite);
        }
    }

    private void fireOnSuiteFinished(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteFinished(suite);
        }
    }

    private void fireOnCustomProgressTestsCategory(String categoryName, int testCount) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFailed();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myEventsListeners.clear();
                if (!(GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed!");
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
            }
        });
    }

    private void setNodeAndAncestorsRunning(Node lowestNode) {
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING);
            GoogleCloudTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(Node node, State terminateState) {
        node.setState(terminateState);
        this.myRunningTestNodes.remove(node);
    }

    private Node findActiveNode() {
        if (this.myRunningTestNodes.isEmpty()) {
            return this.myTestsRootNode;
        }
        return this.myRunningTestNodes.iterator().next();
    }

    private void logProblem(String msg) {
        this.logProblem(msg, SMTestRunnerConnectionUtil.isInDebugMode());
    }

    private void logProblem(String msg, boolean throwError) {
        String text = "[" + this.myTestFrameworkName + "] " + msg;
        if (throwError) {
            LOG.error(text);
        } else {
            LOG.warn(text);
        }
    }

    private static class Node {
        private final int myId;
        private final Node myParentNode;
        private final GoogleCloudTestProxy myProxy;
        private State myState;

        Node(int id, Node parentNode, GoogleCloudTestProxy proxy) {
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        public int getId() {
            return this.myId;
        }

        public Node getParentNode() {
            return this.myParentNode;
        }

        public GoogleCloudTestProxy getProxy() {
            return this.myProxy;
        }

        public State getState() {
            return this.myState;
        }

        public void setState(State newState) {
            boolean accepted = false;
            if (this.myState == State.NOT_RUNNING || this.myState == State.RUNNING) {
                boolean bl = accepted = this.myState.ordinal() < newState.ordinal();
            }
            if (!accepted) {
                throw new RuntimeException("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString());
            }
            this.myState = newState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId;
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? String.valueOf(this.myParentNode.getId()) : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

