/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.ManualTargetChooser;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ShowChooserTarget;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.google.gct.testing.CloudOptionEnablementChecker;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.android.CloudMatrixTestRunningState;
import com.google.gct.testing.android.CloudTargetUtil;
import com.google.gct.testing.android.CloudTestMatrixTargetConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class CloudTestMatrixTarget
extends DeployTarget {
    public String getId() {
        return "CLOUD_DEVICE_MATRIX";
    }

    public String getDisplayName() {
        return "Cloud Test Lab Device Matrix";
    }

    public DeployTargetState createState() {
        return new State();
    }

    public DeviceTarget getTarget(DeployTargetState state, AndroidFacet facet, DeviceCount deviceCount, boolean debug, int runConfigId, ConsolePrinter printer) {
        return new ManualTargetChooser(new ShowChooserTarget.State(), facet, runConfigId).getTarget(printer, deviceCount, debug);
    }

    public DeployTargetConfigurable createConfigurable(Project project, Disposable parentDisposable, DeployTargetConfigurableContext context) {
        return new CloudTestMatrixTargetConfigurable(project, parentDisposable, context);
    }

    public boolean showInDevicePicker() {
        return true;
    }

    public boolean isApplicable(boolean isTestConfig) {
        return isTestConfig && CloudOptionEnablementChecker.isCloudOptionEnabled();
    }

    public boolean hasCustomRunProfileState(Executor executor) {
        return !(executor instanceof DefaultDebugExecutor);
    }

    public RunProfileState getRunProfileState(Executor executor, ExecutionEnvironment environment, DeployTargetState targetState) throws ExecutionException {
        RunProfile runProfile = environment.getRunProfile();
        if (!(runProfile instanceof AndroidTestRunConfiguration)) {
            return null;
        }
        AndroidTestRunConfiguration runConfiguration = (AndroidTestRunConfiguration)runProfile;
        AndroidFacet facet = AndroidFacet.getInstance((Module)((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule());
        State cloudTargetState = (State)targetState;
        return new CloudMatrixTestRunningState(environment, facet, runConfiguration, cloudTargetState.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID, cloudTargetState.SELECTED_CLOUD_MATRIX_PROJECT_ID);
    }

    public static final class State
    extends DeployTargetState {
        public int SELECTED_CLOUD_MATRIX_CONFIGURATION_ID = -1;
        public String SELECTED_CLOUD_MATRIX_PROJECT_ID = "";

        public List<ValidationError> validate(AndroidFacet facet) {
            return CloudTargetUtil.validate(facet, CloudConfiguration.Kind.MATRIX, this.SELECTED_CLOUD_MATRIX_PROJECT_ID, this.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID);
        }
    }
}

