/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.google.gct.testing.CloudConfigurationHelper;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;

public class CloudDeviceNameRenderer
implements DeviceNameRendererEx {
    public boolean isApplicable(IDevice device) {
        return CloudConfigurationHelper.getCloudDeviceConfiguration(device) != null;
    }

    public void render(IDevice device, ColoredTextContainer component) {
        component.setIcon(CloudConfigurationHelper.getCloudDeviceIcon());
        String cloudDeviceConfiguration = CloudConfigurationHelper.getCloudDeviceConfiguration(device);
        if (device.getState() == IDevice.DeviceState.OFFLINE) {
            component.append("Launching " + cloudDeviceConfiguration, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else {
            component.append(cloudDeviceConfiguration, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

