/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import com.google.api.services.testing.model.AndroidDevice;
import com.google.api.services.testing.model.Device;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class GhostCloudDevice
implements IDevice {
    private final Device device;

    public GhostCloudDevice(Device device) {
        this.device = device;
    }

    public String getSerialNumber() {
        return "N/A";
    }

    public String getEncodedConfigurationInstance() {
        AndroidDevice androidDevice = this.device.getAndroidDevice();
        return androidDevice.getAndroidModelId() + "-" + androidDevice.getAndroidVersionId() + "-" + androidDevice.getLocale() + "-" + androidDevice.getOrientation();
    }

    public String getAvdName() {
        return null;
    }

    public IDevice.DeviceState getState() {
        return IDevice.DeviceState.OFFLINE;
    }

    public Map<String, String> getProperties() {
        return null;
    }

    public int getPropertyCount() {
        return 0;
    }

    public String getProperty(String name) {
        if (name.equals("ro.build.version.sdk")) {
            return this.device.getAndroidDevice().getAndroidVersionId();
        }
        return null;
    }

    public boolean arePropertiesSet() {
        return false;
    }

    public String getPropertySync(String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return null;
    }

    public String getPropertyCacheOrSync(String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return null;
    }

    public boolean supportsFeature(IDevice.Feature feature) {
        return true;
    }

    public boolean supportsFeature(IDevice.HardwareFeature feature) {
        return feature != IDevice.HardwareFeature.WATCH;
    }

    public String getMountPoint(String name) {
        return null;
    }

    public boolean isOnline() {
        return false;
    }

    public boolean isEmulator() {
        return false;
    }

    public boolean isOffline() {
        return true;
    }

    public boolean isBootLoader() {
        return false;
    }

    public boolean hasClients() {
        return false;
    }

    public Client[] getClients() {
        return new Client[0];
    }

    public Client getClient(String applicationName) {
        return null;
    }

    public SyncService getSyncService() throws TimeoutException, AdbCommandRejectedException, IOException {
        return null;
    }

    public FileListingService getFileListingService() {
        return null;
    }

    public RawImage getScreenshot() throws TimeoutException, AdbCommandRejectedException, IOException {
        return null;
    }

    public RawImage getScreenshot(long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, IOException {
        return null;
    }

    public void startScreenRecorder(String remoteFilePath, ScreenRecorderOptions options, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
    }

    public void executeShellCommand(String command, IShellOutputReceiver receiver, int maxTimeToOutputResponse) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
    }

    public void executeShellCommand(String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
    }

    public void runEventLogService(LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
    }

    public void runLogService(String logname, LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
    }

    public void createForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
    }

    public void createForward(int localPort, String remoteSocketName, IDevice.DeviceUnixSocketNamespace namespace) throws TimeoutException, AdbCommandRejectedException, IOException {
    }

    public void removeForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
    }

    public void removeForward(int localPort, String remoteSocketName, IDevice.DeviceUnixSocketNamespace namespace) throws TimeoutException, AdbCommandRejectedException, IOException {
    }

    public String getClientName(int pid) {
        return null;
    }

    public void pushFile(String local, String remote) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
    }

    public void pullFile(String remote, String local) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
    }

    public void installPackage(String packageFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
    }

    public void installPackages(List<String> apkFilePaths, int timeOutInMs, boolean reinstall, String ... extraArgs) throws InstallException {
    }

    public String syncPackageToDevice(String localFilePath) throws TimeoutException, AdbCommandRejectedException, IOException, SyncException {
        return null;
    }

    public void installRemotePackage(String remoteFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
    }

    public void removeRemotePackage(String remoteFilePath) throws InstallException {
    }

    public String uninstallPackage(String packageName) throws InstallException {
        return null;
    }

    public void reboot(String into) throws TimeoutException, AdbCommandRejectedException, IOException {
    }

    public boolean root() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return false;
    }

    public boolean isRoot() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return false;
    }

    public Integer getBatteryLevel() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return null;
    }

    public Integer getBatteryLevel(long freshnessMs) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return null;
    }

    public Future<Integer> getBattery() {
        return null;
    }

    public Future<Integer> getBattery(long freshnessTime, TimeUnit timeUnit) {
        return null;
    }

    public List<String> getAbis() {
        return null;
    }

    public int getDensity() {
        return 0;
    }

    public String getLanguage() {
        return null;
    }

    public String getRegion() {
        return null;
    }

    public int getApiLevel() {
        String apiString = this.device.getAndroidDevice().getAndroidVersionId();
        if (apiString == null) {
            throw new IllegalStateException("Unexpected error: Device does not have a build API level.");
        }
        try {
            return Integer.parseInt(apiString);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Unexpected error: Build API level '" + apiString + "' is not an integer: ");
        }
    }

    public String getName() {
        return "Cloud device: " + this.device.getId();
    }

    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
    }

    public Future<String> getSystemProperty(String name) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GhostCloudDevice that = (GhostCloudDevice)o;
        if (this.device == null) {
            return that.device == null;
        }
        if (that.device == null) {
            return false;
        }
        return this.device.getId().equals(that.device.getId());
    }

    public int hashCode() {
        return this.device != null ? this.device.getId().hashCode() : 0;
    }
}

