/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.api.client.util.Lists;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.dimension.DeviceDimension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class ConfigurationInstance {
    public static final Function<CloudTestingType, String> GET_RESULTS_VIEWER_DISPLAY_NAME = new Function<CloudTestingType, String>(){

        public String apply(CloudTestingType input) {
            return input.getResultsViewerDisplayName();
        }
    };
    public static final Function<CloudTestingType, String> GET_ENCODED_NAME = new Function<CloudTestingType, String>(){

        public String apply(CloudTestingType input) {
            return input.getId();
        }
    };
    public static final String DISPLAY_NAME_DELIMITER = " | ";
    public static final String ENCODED_NAME_DELIMITER = "-";
    private final Map<String, CloudTestingType> typesByDimensionName = new LinkedHashMap<String, CloudTestingType>();
    private boolean isVirtual = false;

    private ConfigurationInstance() {
    }

    public static ConfigurationInstance parseFromEncodedString(String configurationInstance) {
        return ConfigurationInstance.parse(GET_ENCODED_NAME, ENCODED_NAME_DELIMITER, configurationInstance);
    }

    public static ConfigurationInstance parseFromResultsViewerDisplayString(String configurationInstance) {
        return ConfigurationInstance.parse(GET_RESULTS_VIEWER_DISPLAY_NAME, DISPLAY_NAME_DELIMITER, configurationInstance);
    }

    private static ConfigurationInstance parse(Function<CloudTestingType, String> typeToNameFunction, String delimiter, String input) {
        ConfigurationInstance result = new ConfigurationInstance();
        ArrayList allTypes = Lists.newArrayList((Iterable)Iterables.concat(CloudConfigurationHelper.getAllDimensionTypes().values()));
        ImmutableMap nameToTypeMap = Maps.uniqueIndex((Iterable)allTypes, typeToNameFunction);
        for (String name : input.split(Pattern.quote(delimiter))) {
            ConfigurationInstance.recordType(result, (CloudTestingType)nameToTypeMap.get((Object)name));
        }
        return result;
    }

    private static void recordType(ConfigurationInstance result, CloudTestingType type) {
        String dimensionName = null;
        for (Map.Entry<String, List<? extends CloudTestingType>> entry : CloudConfigurationHelper.getAllDimensionTypes().entrySet()) {
            if (!entry.getValue().contains(type)) continue;
            dimensionName = entry.getKey();
            break;
        }
        if (dimensionName == null) {
            throw new NoSuchElementException("Could not find the corresponding dimension for type: " + type.getResultsViewerDisplayName());
        }
        if (type instanceof DeviceDimension.Device) {
            result.isVirtual = ((DeviceDimension.Device)type).isVirtual();
        }
        result.typesByDimensionName.put(dimensionName, type);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public CloudTestingType getTypeForDimension(CloudConfigurationDimension dimension) {
        return this.typesByDimensionName.get(dimension.getDisplayName());
    }

    public ConfigurationInstance(List<CloudTestingType> types) {
        for (CloudTestingType type : types) {
            ConfigurationInstance.recordType(this, type);
        }
    }

    public String getEncodedString() {
        return this.getRepresentationString(GET_ENCODED_NAME, ENCODED_NAME_DELIMITER);
    }

    public String getResultsViewerDisplayString() {
        return this.getRepresentationString(GET_RESULTS_VIEWER_DISPLAY_NAME, DISPLAY_NAME_DELIMITER);
    }

    private String getRepresentationString(Function<CloudTestingType, String> typeToNameFunction, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (CloudTestingType type : this.typesByDimensionName.values()) {
            sb.append((String)typeToNameFunction.apply((Object)type) + delimiter);
        }
        sb.replace(sb.length() - delimiter.length(), sb.length(), "");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationInstance that = (ConfigurationInstance)o;
        return ((Object)this.typesByDimensionName).equals(that.typesByDimensionName);
    }

    public int hashCode() {
        return ((Object)this.typesByDimensionName).hashCode();
    }
}

