/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.gct.testing.CloudConfigurationHelper;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import java.util.concurrent.TimeUnit;

public class CloudOptionEnablementChecker
implements ApplicationComponent {
    private static final String ENABLE_CLOUD_TESTING_REMOTELY = "com.google.gct.enable.cloud.testing";
    private static final String LOCAL_ENABLE_FLAG = "enable.google.cloud.testing.plugin";

    public void initComponent() {
        if (!CloudOptionEnablementChecker.isCloudOptionEnabled()) {
            // empty if block
        }
    }

    public void disposeComponent() {
    }

    public String getComponentName() {
        return "CloudOptionEnablementChecker";
    }

    public static boolean isCloudOptionEnabled() {
        return Boolean.getBoolean(LOCAL_ENABLE_FLAG);
    }

    private class EnablementCheckerRunnable
    implements Runnable {
        private EnablementCheckerRunnable() {
        }

        @Override
        public void run() {
            if (!CloudOptionEnablementChecker.isCloudOptionEnabled()) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (CloudConfigurationHelper.isCloudTestingEnabledRemotely()) {
                            PropertiesComponent.getInstance().setValue(CloudOptionEnablementChecker.ENABLE_CLOUD_TESTING_REMOTELY, "true");
                        }
                    }
                });
                JobScheduler.getScheduler().schedule(this, 30L, TimeUnit.MINUTES);
            }
        }
    }
}

