/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.DnsMessage;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResource;
import io.netty.handler.codec.dns.DnsResponseHeader;
import java.net.InetSocketAddress;

public final class DnsResponse
extends DnsMessage {
    private final InetSocketAddress sender;

    public DnsResponse(int id, InetSocketAddress sender) {
        super(id);
        if (sender == null) {
            throw new NullPointerException("sender");
        }
        this.sender = sender;
    }

    public InetSocketAddress sender() {
        return this.sender;
    }

    @Override
    public DnsResponse addAnswer(DnsResource answer) {
        super.addAnswer(answer);
        return this;
    }

    @Override
    public DnsResponse addQuestion(DnsQuestion question) {
        super.addQuestion(question);
        return this;
    }

    @Override
    public DnsResponse addAuthorityResource(DnsResource resource) {
        super.addAuthorityResource(resource);
        return this;
    }

    @Override
    public DnsResponse addAdditionalResource(DnsResource resource) {
        super.addAdditionalResource(resource);
        return this;
    }

    @Override
    public DnsResponse touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public DnsResponse retain() {
        super.retain();
        return this;
    }

    @Override
    public DnsResponse retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public DnsResponse touch() {
        super.touch();
        return this;
    }

    @Override
    public DnsResponseHeader header() {
        return (DnsResponseHeader)super.header();
    }

    @Override
    protected DnsResponseHeader newHeader(int id) {
        return new DnsResponseHeader(this, id);
    }
}

