/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.idea.svn.FilePathUtil;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.update.SvnPanel;
import org.jetbrains.idea.svn.update.SvnSelectRevisionUtil;
import org.jetbrains.idea.svn.update.UpdateRootInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnUpdateRootOptionsPanel
implements SvnPanel {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.update.SvnUpdateRootOptionsPanel.SvnUpdateRootOptionsPanel");
    private TextFieldWithBrowseButton myURLText;
    private JCheckBox myRevisionBox;
    private TextFieldWithBrowseButton myRevisionText;
    private final SvnVcs myVcs;
    private JPanel myPanel;
    private final FilePath myRoot;
    private JCheckBox myUpdateToSpecificUrl;
    private TextFieldWithBrowseButton myBranchField;
    private JLabel myBranchLabel;
    private JLabel myUrlLabel;
    private JLabel myCopyType;
    private SVNURL mySourceUrl;

    public SvnUpdateRootOptionsPanel(FilePath root, final SvnVcs vcs, Collection<FilePath> roots) {
        this.myRoot = root;
        this.myVcs = vcs;
        this.$$$setupUI$$$();
        this.myURLText.setEditable(true);
        this.myURLText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnUpdateRootOptionsPanel.this.chooseUrl();
            }
        });
        this.myBranchField.setEditable(false);
        this.myBranchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnUpdateRootOptionsPanel.this.chooseBranch();
            }
        });
        this.myBranchLabel.setLabelFor((Component)this.myBranchField);
        this.myUrlLabel.setLabelFor((Component)this.myURLText);
        this.myUpdateToSpecificUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SvnUpdateRootOptionsPanel.this.myUpdateToSpecificUrl.isSelected()) {
                    SvnUpdateRootOptionsPanel.this.myURLText.setEnabled(true);
                    SvnUpdateRootOptionsPanel.this.myBranchField.setEnabled(SvnUpdateRootOptionsPanel.this.mySourceUrl != null);
                } else {
                    SvnUpdateRootOptionsPanel.this.myURLText.setEnabled(false);
                    SvnUpdateRootOptionsPanel.this.myBranchField.setEnabled(false);
                }
            }
        });
        this.myRevisionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == SvnUpdateRootOptionsPanel.this.myRevisionBox) {
                    SvnUpdateRootOptionsPanel.this.myRevisionText.setEnabled(SvnUpdateRootOptionsPanel.this.myRevisionBox.isSelected());
                    if (SvnUpdateRootOptionsPanel.this.myRevisionBox.isSelected()) {
                        if (SvnUpdateRootOptionsPanel.this.myRevisionText.getText().trim().isEmpty()) {
                            SvnUpdateRootOptionsPanel.this.myRevisionText.setText("HEAD");
                        }
                        SvnUpdateRootOptionsPanel.this.myRevisionText.getTextField().selectAll();
                        SvnUpdateRootOptionsPanel.this.myRevisionText.requestFocus();
                    }
                }
            }
        });
        this.myRevisionText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnRepositoryLocation location;
                Project project = vcs.getProject();
                SvnChangeList repositoryVersion = SvnSelectRevisionUtil.chooseCommittedChangeList(project, location = new SvnRepositoryLocation(SvnUpdateRootOptionsPanel.this.myURLText.getText()), SvnUpdateRootOptionsPanel.this.myRoot.getVirtualFile());
                if (repositoryVersion != null) {
                    SvnUpdateRootOptionsPanel.this.myRevisionText.setText(String.valueOf(repositoryVersion.getNumber()));
                }
            }
        });
        this.myRevisionText.setText(SVNRevision.HEAD.toString());
        this.myRevisionText.getTextField().selectAll();
        this.myRevisionText.setEnabled(this.myRevisionBox.isSelected());
        this.myURLText.setEnabled(this.myUpdateToSpecificUrl.isSelected());
        this.myBranchField.setEnabled(this.myUpdateToSpecificUrl.isSelected() && this.mySourceUrl != null);
        boolean revisionCanBeSpecifiedForRoot = !FilePathUtil.isNested(roots, this.myRoot) || this.isRevisionCanBeSpecifiedForRoot();
        this.myRevisionBox.setEnabled(revisionCanBeSpecifiedForRoot);
        this.myRevisionText.setEnabled(revisionCanBeSpecifiedForRoot);
        this.myCopyType.setVisible(!revisionCanBeSpecifiedForRoot);
        this.myCopyType.setFont(this.myCopyType.getFont().deriveFont(2));
        this.myUpdateToSpecificUrl.setEnabled(revisionCanBeSpecifiedForRoot);
    }

    private boolean isRevisionCanBeSpecifiedForRoot() {
        RootUrlInfo info = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(this.myRoot.getIOFile());
        if (info != null) {
            boolean isExternalOrSwitched;
            boolean bl = isExternalOrSwitched = NestedCopyType.external.equals((Object)info.getType()) || NestedCopyType.switched.equals((Object)info.getType());
            if (isExternalOrSwitched) {
                this.myCopyType.setText(info.getType().getName() + " copy");
            }
            return !isExternalOrSwitched;
        }
        return true;
    }

    private void chooseBranch() {
        if (this.mySourceUrl == null) {
            this.myBranchField.setEnabled(false);
            return;
        }
        SelectBranchPopup.show(this.myVcs.getProject(), this.myRoot.getVirtualFile(), new SelectBranchPopup.BranchSelectedCallback(){

            @Override
            public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
                String branchRelativeUrl;
                SvnBranchConfigurationNew branchConfiguration = SvnUpdateRootOptionsPanel.this.getBranchConfiguration();
                String string = branchRelativeUrl = branchConfiguration != null ? branchConfiguration.getRelativeUrl(SvnUpdateRootOptionsPanel.this.mySourceUrl.toString()) : null;
                if (SvnUpdateRootOptionsPanel.this.mySourceUrl == null || branchRelativeUrl == null) {
                    SvnUpdateRootOptionsPanel.this.myBranchField.setText("");
                } else {
                    try {
                        SvnUpdateRootOptionsPanel.this.myURLText.setText(SVNURL.parseURIEncoded((String)url).appendPath(branchRelativeUrl, true).toDecodedString());
                    }
                    catch (SVNException e) {
                        LOG.error((Throwable)e);
                    }
                    SvnUpdateRootOptionsPanel.this.myBranchField.setText(SVNPathUtil.tail((String)url));
                }
            }
        }, SvnBundle.message("select.branch.popup.general.title", new Object[0]), this.myPanel);
    }

    private void chooseUrl() {
        SVNURL selected = SelectLocationDialog.selectLocation(this.myVcs.getProject(), this.myURLText.getText());
        if (selected != null) {
            this.myURLText.setText(selected.toDecodedString());
        }
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    private SVNURL getBranchForUrl(SVNURL url) {
        RootUrlInfo rootInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(this.myRoot.getIOFile());
        return rootInfo != null && url != null ? SvnUtil.getBranchForUrl(this.myVcs, rootInfo.getVirtualFile(), url) : null;
    }

    private SvnBranchConfigurationNew getBranchConfiguration() {
        RootUrlInfo rootInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(this.myRoot.getIOFile());
        return rootInfo != null ? SvnBranchConfigurationManager.getInstance(this.myVcs.getProject()).get(rootInfo.getVirtualFile()) : null;
    }

    @Override
    public void reset(SvnConfiguration configuration) {
        UpdateRootInfo rootInfo = configuration.getUpdateRootInfo(this.myRoot.getIOFile(), this.myVcs);
        this.mySourceUrl = rootInfo.getUrl();
        SVNURL branchUrl = this.getBranchForUrl(this.mySourceUrl);
        if (branchUrl != null) {
            this.myBranchField.setText(SVNPathUtil.tail((String)branchUrl.toDecodedString()));
        }
        this.myURLText.setText(this.mySourceUrl != null ? this.mySourceUrl.toDecodedString() : "");
        this.myRevisionBox.setSelected(rootInfo.isUpdateToRevision());
        this.myRevisionText.setText(rootInfo.getRevision().toString());
        this.myUpdateToSpecificUrl.setSelected(false);
        this.myRevisionText.setEnabled(this.myRevisionBox.isSelected());
        this.myURLText.setEnabled(this.myUpdateToSpecificUrl.isSelected());
        this.myBranchField.setEnabled(this.myUpdateToSpecificUrl.isSelected() && this.mySourceUrl != null);
    }

    @Override
    public void apply(SvnConfiguration configuration) throws ConfigurationException {
        UpdateRootInfo rootInfo = configuration.getUpdateRootInfo(this.myRoot.getIOFile(), this.myVcs);
        if (this.myUpdateToSpecificUrl.isSelected()) {
            try {
                rootInfo.setUrl(SvnUtil.createUrl(this.myURLText.getText(), false));
            }
            catch (SvnBindException e) {
                throw new ConfigurationException("Invalid url: " + this.myURLText.getText());
            }
        }
        rootInfo.setUpdateToRevision(this.myRevisionBox.isSelected());
        SVNRevision revision = SVNRevision.parse((String)this.myRevisionText.getText());
        if (!revision.isValid()) {
            throw new ConfigurationException(SvnBundle.message("invalid.svn.revision.error.message", this.myRevisionText.getText()));
        }
        rootInfo.setRevision(revision);
    }

    @Override
    public boolean canApply() {
        return true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel3;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUpdateToSpecificUrl = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("update.configuration.specific.url"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCopyType = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myURLText = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myBranchField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myUrlLabel = jLabel2 = new JLabel();
        jLabel2.setText("URL:");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myBranchLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("update.switch.to.branch.text"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRevisionBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.update.switch.configurable.to.specific.revision"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRevisionText = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, new Dimension(100, -1), new Dimension(100, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

