/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.FilePatchInProgress;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.treeConflict.ApplyPatchSaveToFileExecutor;
import org.jetbrains.idea.svn.treeConflict.SvnTreeConflictResolver;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class MergeFromTheirsResolver {
    private final SvnVcs myVcs;
    private final TreeConflictDescription myDescription;
    private final Change myChange;
    private final FilePath myOldFilePath;
    private final FilePath myNewFilePath;
    private final String myOldPresentation;
    private final String myNewPresentation;
    private final SvnRevisionNumber myCommittedRevision;
    private Boolean myAdd;
    private final List<Change> myTheirsChanges;
    private final List<Change> myTheirsBinaryChanges;
    private final List<VcsException> myWarnings;
    private List<TextFilePatch> myTextPatches;
    private VirtualFile myBaseForPatch;

    public MergeFromTheirsResolver(SvnVcs vcs, TreeConflictDescription description, Change change, SvnRevisionNumber revision) {
        this.myVcs = vcs;
        this.myDescription = description;
        this.myChange = change;
        this.myCommittedRevision = revision;
        this.myOldFilePath = this.myChange.getBeforeRevision().getFile();
        this.myNewFilePath = this.myChange.getAfterRevision().getFile();
        this.myBaseForPatch = ChangesUtil.findValidParentAccurately((FilePath)this.myNewFilePath);
        this.myOldPresentation = TreeConflictRefreshablePanel.filePath(this.myOldFilePath);
        this.myNewPresentation = TreeConflictRefreshablePanel.filePath(this.myNewFilePath);
        this.myTheirsChanges = new ArrayList<Change>();
        this.myTheirsBinaryChanges = new ArrayList<Change>();
        this.myWarnings = new ArrayList<VcsException>();
        this.myTextPatches = Collections.emptyList();
    }

    public void execute() {
        int ok = Messages.showOkCancelDialog((Project)this.myVcs.getProject(), (String)(this.myChange.isMoved() ? SvnBundle.message("confirmation.resolve.tree.conflict.merge.moved", this.myOldPresentation, this.myNewPresentation) : SvnBundle.message("confirmation.resolve.tree.conflict.merge.renamed", this.myOldPresentation, this.myNewPresentation)), (String)"Resolve tree conflict", (Icon)Messages.getQuestionIcon());
        if (0 != ok) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Continuation fragmented = Continuation.createFragmented((Project)this.myVcs.getProject(), (boolean)false);
        fragmented.addExceptionHandler(VcsException.class, (Consumer)new Consumer<VcsException>(){

            public void consume(VcsException e) {
                MergeFromTheirsResolver.this.myWarnings.add(e);
                if (e.isWarning()) {
                    return;
                }
                AbstractVcsHelper.getInstance((Project)MergeFromTheirsResolver.this.myVcs.getProject()).showErrors(MergeFromTheirsResolver.this.myWarnings, "Resolve tree conflict");
            }
        });
        SmartList tasks = new SmartList();
        tasks.add(this.myDescription.isDirectory() ? new PreloadChangesContentsForDir() : new PreloadChangesContentsForFile());
        tasks.add(new ConvertTextPaths());
        tasks.add(new PatchCreator());
        tasks.add(new SelectPatchesInApplyPatchDialog());
        tasks.add(new SelectBinaryFiles());
        fragmented.run((List)tasks);
    }

    private void appendResolveConflictToContext(ContinuationContext context) {
        context.next(new TaskDescriptor[]{new ResolveConflictInSvn()});
    }

    private void appendTailToContextLast(ContinuationContext context) {
        context.last(new TaskDescriptor[]{new ApplyBinaryChanges(), new FinalNotification()});
    }

    private List<Change> filterOutBinary(List<Change> paths) {
        SmartList result = null;
        Iterator<Change> iterator = paths.iterator();
        while (iterator.hasNext()) {
            Change change = iterator.next();
            if (!ChangesUtil.isBinaryChange((Change)change)) continue;
            result = result == null ? new SmartList() : result;
            result.add(change);
            iterator.remove();
        }
        return result;
    }

    private Collection<FilePath> chooseBinaryFiles(List<Change> converted, Set<FilePath> paths) {
        String singleMessage = "";
        if (paths.size() == 1) {
            Change change = converted.get(0);
            FileStatus status = change.getFileStatus();
            FilePath path = ChangesUtil.getFilePath((Change)change);
            String stringPath = TreeConflictRefreshablePanel.filePath(path);
            singleMessage = FileStatus.DELETED.equals(status) ? "Delete binary file " + stringPath + " (according to theirs changes)?" : (FileStatus.ADDED.equals(status) ? "Create binary file " + stringPath + " (according to theirs changes)?" : "Apply changes to binary file " + stringPath + " (according to theirs changes)?");
        }
        return AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).selectFilePathsToProcess(new ArrayList<FilePath>(paths), "Resolve tree conflict", "Select binary files to patch", "Resolve tree conflict", singleMessage, new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return null;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
            }

            public boolean isPersistent() {
                return false;
            }
        });
    }

    private List<Change> convertPaths(List<Change> changesForPatch) throws VcsException {
        this.initAddOption();
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Change change : changesForPatch) {
            if (!this.isUnderOldDir(change, this.myOldFilePath)) continue;
            SimpleContentRevision before = null;
            Object after = null;
            if (change.getBeforeRevision() != null) {
                before = new SimpleContentRevision(change.getBeforeRevision().getContent(), this.rebasePath(this.myOldFilePath, this.myNewFilePath, change.getBeforeRevision().getFile()), change.getBeforeRevision().getRevisionNumber().asString());
            }
            if (change.getAfterRevision() != null) {
                after = this.myAdd != false && (change.getBeforeRevision() == null || change.isMoved() || change.isRenamed()) ? change.getAfterRevision() : new SimpleContentRevision(change.getAfterRevision().getContent(), this.rebasePath(this.myOldFilePath, this.myNewFilePath, change.getAfterRevision().getFile()), change.getAfterRevision().getRevisionNumber().asString());
            }
            changes.add(new Change(before, after));
        }
        return changes;
    }

    private boolean isUnderOldDir(Change change, FilePath path) {
        boolean isUnder;
        if (change.getBeforeRevision() != null && (isUnder = FileUtil.isAncestor((File)path.getIOFile(), (File)change.getBeforeRevision().getFile().getIOFile(), (boolean)true))) {
            return true;
        }
        if (change.getAfterRevision() != null && (isUnder = FileUtil.isAncestor((File)path.getIOFile(), (File)change.getAfterRevision().getFile().getIOFile(), (boolean)true))) {
            return isUnder;
        }
        return false;
    }

    private FilePath rebasePath(FilePath oldBase, FilePath newBase, FilePath path) {
        String relativePath = FileUtil.getRelativePath((String)oldBase.getPath(), (String)path.getPath(), (char)File.separatorChar);
        return ((FilePathImpl)newBase).createChild(relativePath, path.isDirectory());
    }

    private void preloadRevisionContents(ContentRevision cr) throws VcsException {
        if (cr instanceof BinaryContentRevision) {
            ((BinaryContentRevision)cr).getBinaryContent();
        } else {
            cr.getContent();
        }
    }

    private List<CommittedChangeList> loadSvnChangeListsForPatch(TreeConflictDescription description) throws VcsException {
        long max = description.getSourceRightVersion().getPegRevision();
        long min = description.getSourceLeftVersion().getPegRevision();
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_BEFORE = "" + max;
        settings.CHANGE_AFTER = "" + min;
        List committedChanges = this.myVcs.getCachingCommittedChangesProvider().getCommittedChanges(settings, (RepositoryLocation)new SvnRepositoryLocation(description.getSourceRightVersion().getRepositoryRoot().toString()), 0);
        ArrayList<CommittedChangeList> lst = new ArrayList<CommittedChangeList>(committedChanges.size() - 1);
        for (SvnChangeList change : committedChanges) {
            if (change.getNumber() == min) continue;
            lst.add(change);
        }
        return lst;
    }

    private void initAddOption() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAdd == null) {
            this.myAdd = this.getAddedFilesPlaceOption();
        }
    }

    private boolean getAddedFilesPlaceOption() {
        final SvnConfiguration configuration = SvnConfiguration.getInstance(this.myVcs.getProject());
        boolean add = Boolean.TRUE.equals(configuration.isKeepNewFilesAsIsForTreeConflictMerge());
        if (configuration.isKeepNewFilesAsIsForTreeConflictMerge() != null) {
            return add;
        }
        if (!this.containAdditions(this.myTheirsChanges) && !this.containAdditions(this.myTheirsBinaryChanges)) {
            return false;
        }
        return 0 == ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Resolve tree conflict", (String)"Keep newly created file(s) in their original place?").yesText("Keep")).noText("Move")).doNotAsk(new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    if (exitCode == 0) {
                        configuration.setKeepNewFilesAsIsForTreeConflictMerge(true);
                    } else {
                        configuration.setKeepNewFilesAsIsForTreeConflictMerge(false);
                    }
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
            }
        })).show();
    }

    private boolean containAdditions(List<Change> changes) {
        boolean addFound = false;
        for (Change change : changes) {
            if (change.getBeforeRevision() != null && !change.isMoved() && !change.isRenamed()) continue;
            addFound = true;
            break;
        }
        return addFound;
    }

    private class PreloadChangesContentsForDir
    extends TaskDescriptor {
        private PreloadChangesContentsForDir() {
            super("Getting base and theirs revisions content", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            List changesForPatch;
            try {
                List lst = MergeFromTheirsResolver.this.loadSvnChangeListsForPatch(MergeFromTheirsResolver.this.myDescription);
                changesForPatch = CommittedChangesTreeBrowser.collectChanges((List)lst, (boolean)true);
                for (Change change : changesForPatch) {
                    if (change.getBeforeRevision() != null) {
                        MergeFromTheirsResolver.this.preloadRevisionContents(change.getBeforeRevision());
                    }
                    if (change.getAfterRevision() == null) continue;
                    MergeFromTheirsResolver.this.preloadRevisionContents(change.getAfterRevision());
                }
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
                return;
            }
            List binaryChanges = MergeFromTheirsResolver.this.filterOutBinary(changesForPatch);
            if (binaryChanges != null && !binaryChanges.isEmpty()) {
                MergeFromTheirsResolver.this.myTheirsBinaryChanges.addAll(binaryChanges);
            }
            if (!changesForPatch.isEmpty()) {
                MergeFromTheirsResolver.this.myTheirsChanges.addAll(changesForPatch);
            }
        }
    }

    private class PreloadChangesContentsForFile
    extends TaskDescriptor {
        private PreloadChangesContentsForFile() {
            super("Getting base and theirs revisions content", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            SvnContentRevision base = SvnContentRevision.createBaseRevision(MergeFromTheirsResolver.this.myVcs, MergeFromTheirsResolver.this.myNewFilePath, MergeFromTheirsResolver.this.myCommittedRevision.getRevision());
            SvnContentRevision remote = SvnContentRevision.createRemote(MergeFromTheirsResolver.this.myVcs, MergeFromTheirsResolver.this.myOldFilePath, SVNRevision.create((long)MergeFromTheirsResolver.this.myDescription.getSourceRightVersion().getPegRevision()));
            try {
                SimpleContentRevision newBase = new SimpleContentRevision(base.getContent(), MergeFromTheirsResolver.this.myNewFilePath, base.getRevisionNumber().asString());
                SimpleContentRevision newRemote = new SimpleContentRevision(remote.getContent(), MergeFromTheirsResolver.this.myNewFilePath, remote.getRevisionNumber().asString());
                MergeFromTheirsResolver.this.myTheirsChanges.add(new Change((ContentRevision)newBase, (ContentRevision)newRemote));
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
        }
    }

    private class ApplyBinaryChanges
    extends TaskDescriptor {
        private ApplyBinaryChanges() {
            super("", Where.AWT);
        }

        public void run(final ContinuationContext context) {
            if (MergeFromTheirsResolver.this.myTheirsBinaryChanges.isEmpty()) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            final ArrayList dirtyPaths = new ArrayList();
            for (final Change change : MergeFromTheirsResolver.this.myTheirsBinaryChanges) {
                try {
                    application.runWriteAction((ThrowableComputable)new ThrowableComputable<Void, VcsException>(){

                        public Void compute() throws VcsException {
                            try {
                                if (change.getAfterRevision() == null) {
                                    FilePath path = change.getBeforeRevision().getFile();
                                    dirtyPaths.add(path);
                                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path.getIOFile());
                                    if (file == null) {
                                        context.handleException((Exception)((Object)new VcsException("Can not delete file: " + file.getPath(), true)), false);
                                        return null;
                                    }
                                    file.delete(TreeConflictRefreshablePanel.class);
                                } else {
                                    FilePath file = change.getAfterRevision().getFile();
                                    dirtyPaths.add(file);
                                    String parentPath = file.getParentPath().getPath();
                                    VirtualFile parentFile = VfsUtil.createDirectoryIfMissing((String)parentPath);
                                    if (parentFile == null) {
                                        context.handleException((Exception)((Object)new VcsException("Can not create directory: " + parentPath, true)), false);
                                        return null;
                                    }
                                    VirtualFile child = parentFile.createChildData(TreeConflictRefreshablePanel.class, file.getName());
                                    if (child == null) {
                                        context.handleException((Exception)((Object)new VcsException("Can not create file: " + file.getPath(), true)), false);
                                        return null;
                                    }
                                    BinaryContentRevision revision = (BinaryContentRevision)change.getAfterRevision();
                                    byte[] content = revision.getBinaryContent();
                                    if (content == null) {
                                        context.handleException((Exception)((Object)new VcsException("Can not load Theirs content for file " + file.getPath())), false);
                                        return null;
                                    }
                                    child.setBinaryContent(content);
                                }
                            }
                            catch (IOException e) {
                                throw new VcsException((Throwable)e);
                            }
                            return null;
                        }
                    });
                }
                catch (VcsException e) {
                    context.handleException((Exception)((Object)e), true);
                    return;
                }
            }
            VcsDirtyScopeManager.getInstance((Project)MergeFromTheirsResolver.this.myVcs.getProject()).filePathsDirty(dirtyPaths, null);
        }
    }

    private class SelectBinaryFiles
    extends TaskDescriptor {
        private SelectBinaryFiles() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            List converted;
            if (MergeFromTheirsResolver.this.myTheirsBinaryChanges.isEmpty()) {
                return;
            }
            try {
                converted = MergeFromTheirsResolver.this.convertPaths(MergeFromTheirsResolver.this.myTheirsBinaryChanges);
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
                return;
            }
            if (converted.isEmpty()) {
                return;
            }
            HashMap<FilePath, Change> map = new HashMap<FilePath, Change>();
            for (Change change : converted) {
                map.put(ChangesUtil.getFilePath((Change)change), change);
            }
            Collection selected = MergeFromTheirsResolver.this.chooseBinaryFiles(converted, map.keySet());
            MergeFromTheirsResolver.this.myTheirsBinaryChanges.clear();
            for (FilePath filePath : selected) {
                MergeFromTheirsResolver.this.myTheirsBinaryChanges.add(map.get(filePath));
            }
        }
    }

    private class PatchCreator
    extends TaskDescriptor {
        private PatchCreator() {
            super("Creating patch for theirs changes", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            Project project = MergeFromTheirsResolver.this.myVcs.getProject();
            try {
                List patches = IdeaTextPatchBuilder.buildPatch((Project)project, (Collection)MergeFromTheirsResolver.this.myTheirsChanges, (String)MergeFromTheirsResolver.this.myBaseForPatch.getPath(), (boolean)false);
                MergeFromTheirsResolver.this.myTextPatches = ObjectsConvertor.convert((Collection)patches, (Convertor)new Convertor<FilePatch, TextFilePatch>(){

                    public TextFilePatch convert(FilePatch o) {
                        return (TextFilePatch)o;
                    }
                });
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
        }
    }

    private class DirectoryAddition
    extends TaskDescriptor {
        private DirectoryAddition() {
            super("Adding " + MergeFromTheirsResolver.this.myOldPresentation + " to Subversion", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            try {
                MergeFromTheirsResolver.this.myVcs.getFactory(MergeFromTheirsResolver.this.myOldFilePath.getIOFile()).createAddClient().add(MergeFromTheirsResolver.this.myOldFilePath.getIOFile(), Depth.EMPTY, true, false, true, null);
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
        }
    }

    private class TreeConflictApplyTheirsPatchExecutor
    implements ApplyPatchExecutor {
        private final SvnVcs myVcs;
        private final ContinuationContext myInner;
        private final VirtualFile myBaseDir;

        public TreeConflictApplyTheirsPatchExecutor(SvnVcs vcs, ContinuationContext inner, VirtualFile baseDir) {
            this.myVcs = vcs;
            this.myInner = inner;
            this.myBaseDir = baseDir;
        }

        public String getName() {
            return "Apply patch";
        }

        public void apply(MultiMap<VirtualFile, FilePatchInProgress> patchGroups, LocalChangeList localList, String fileName, TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
            List<FilePatch> patches;
            try {
                patches = ApplyPatchSaveToFileExecutor.patchGroupsToOneGroup(patchGroups, this.myBaseDir);
            }
            catch (IOException e) {
                this.myInner.handleException((Exception)e, true);
                return;
            }
            PatchApplier patchApplier = new PatchApplier(this.myVcs.getProject(), this.myBaseDir, patches, localList, null, null);
            patchApplier.scheduleSelf(false, this.myInner, true);
            boolean thereAreCreations = false;
            for (FilePatch patch : patches) {
                if (!patch.isNewFile() && Comparing.equal((String)patch.getAfterName(), (String)patch.getBeforeName())) continue;
                thereAreCreations = true;
                break;
            }
            if (thereAreCreations) {
                this.myInner.next(new TaskDescriptor[]{new DirectoryAddition()});
            }
            MergeFromTheirsResolver.this.appendResolveConflictToContext(this.myInner);
            MergeFromTheirsResolver.this.appendTailToContextLast(this.myInner);
            this.myInner.ping();
        }
    }

    private class SelectPatchesInApplyPatchDialog
    extends TaskDescriptor {
        private SelectPatchesInApplyPatchDialog() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            ChangeListManager clManager = ChangeListManager.getInstance((Project)MergeFromTheirsResolver.this.myVcs.getProject());
            LocalChangeList changeList = clManager.getChangeList(MergeFromTheirsResolver.this.myChange);
            ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(MergeFromTheirsResolver.this.myVcs.getProject(), (ApplyPatchExecutor)new TreeConflictApplyTheirsPatchExecutor(MergeFromTheirsResolver.this.myVcs, context, MergeFromTheirsResolver.this.myBaseForPatch), Collections.singletonList(new ApplyPatchSaveToFileExecutor(MergeFromTheirsResolver.this.myVcs.getProject(), MergeFromTheirsResolver.this.myBaseForPatch)), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, MergeFromTheirsResolver.this.myTextPatches, changeList);
            context.suspend();
            dialog.show();
        }
    }

    private class ConvertTextPaths
    extends TaskDescriptor {
        private ConvertTextPaths() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            MergeFromTheirsResolver.this.initAddOption();
            Object convertedChanges = new SmartList();
            try {
                convertedChanges = MergeFromTheirsResolver.this.convertPaths(MergeFromTheirsResolver.this.myTheirsChanges);
            }
            catch (VcsException e) {
                context.handleException((Exception)((Object)e), true);
            }
            MergeFromTheirsResolver.this.myTheirsChanges.clear();
            MergeFromTheirsResolver.this.myTheirsChanges.addAll(convertedChanges);
        }
    }

    private class ResolveConflictInSvn
    extends TaskDescriptor {
        private ResolveConflictInSvn() {
            super("Accepting working state", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            try {
                new SvnTreeConflictResolver(MergeFromTheirsResolver.this.myVcs, MergeFromTheirsResolver.this.myOldFilePath, null).resolveSelectMineFull();
            }
            catch (VcsException e1) {
                context.handleException((Exception)((Object)e1), false);
            }
        }
    }

    private class FinalNotification
    extends TaskDescriptor {
        private FinalNotification() {
            super("", Where.AWT);
        }

        public void run(ContinuationContext context) {
            StringBuilder message = new StringBuilder().append("Theirs changes merged for ").append(MergeFromTheirsResolver.this.myOldPresentation);
            VcsBalloonProblemNotifier.showOverChangesView((Project)MergeFromTheirsResolver.this.myVcs.getProject(), (String)message.toString(), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
            if (!MergeFromTheirsResolver.this.myWarnings.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)MergeFromTheirsResolver.this.myVcs.getProject()).showErrors(MergeFromTheirsResolver.this.myWarnings, "Resolve tree conflict");
            }
        }
    }
}

