/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnHttpAuthMethodsDefaultChecker;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.svnkit.SvnKitAdminAreaFactorySelector;
import org.jetbrains.idea.svn.svnkit.SvnKitDebugLogger;
import org.jetbrains.idea.svn.svnkit.lowLevel.PrimitivePool;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SvnKitManager {
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance(SvnKitManager.class));
    public static final String LOG_PARAMETER_NAME = "javasvn.log";
    public static final String TRACE_NATIVE_CALLS = "javasvn.log.native";
    public static final String SVNKIT_HTTP_SSL_PROTOCOLS = "svnkit.http.sslProtocols";
    private static String ourExplicitlySetSslProtocols;
    private final SvnVcs myVcs;
    private final Project myProject;
    private final SvnConfiguration myConfiguration;

    public SvnKitManager(SvnVcs vcs) {
        this.myVcs = vcs;
        this.myProject = this.myVcs.getProject();
        this.myConfiguration = this.myVcs.getSvnConfiguration();
        this.refreshSSLProperty();
    }

    public static String getExplicitlySetSslProtocols() {
        return ourExplicitlySetSslProtocols;
    }

    public static boolean isSSLProtocolExplicitlySet() {
        return ourExplicitlySetSslProtocols != null;
    }

    public void refreshSSLProperty() {
        if (SvnKitManager.isSSLProtocolExplicitlySet()) {
            return;
        }
        if (SvnConfiguration.SSLProtocols.all.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.clearProperty(SVNKIT_HTTP_SSL_PROTOCOLS);
        } else if (SvnConfiguration.SSLProtocols.sslv3.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "SSLv3");
        } else if (SvnConfiguration.SSLProtocols.tlsv1.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "TLSv1");
        }
    }

    public void activate() {
        if (SystemInfo.isWindows) {
            if (!SVNJNAUtil.isJNAPresent()) {
                Notifications.Bus.notify((Notification)new Notification(this.myVcs.getDisplayName(), "Subversion plugin: no JNA", "A problem with JNA initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            } else if (!SVNJNAUtil.isWinCryptEnabled()) {
                Notifications.Bus.notify((Notification)new Notification(this.myVcs.getDisplayName(), "Subversion plugin: no encryption", "A problem with encryption module (Crypt32.dll) initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            }
        }
    }

    public ISVNOptions getSvnOptions() {
        return this.myConfiguration.getOptions();
    }

    public SVNRepository createRepository(String url) throws SVNException {
        return this.createRepository(SVNURL.parseURIEncoded((String)url));
    }

    public SVNRepository createRepository(SVNURL url) throws SVNException {
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)url);
        repository.setAuthenticationManager((ISVNAuthenticationManager)this.getAuthenticationManager());
        repository.setTunnelProvider((ISVNTunnelProvider)this.getSvnOptions());
        return repository;
    }

    private ISVNRepositoryPool getPool() {
        return this.getPool((ISVNAuthenticationManager)this.getAuthenticationManager());
    }

    private ISVNRepositoryPool getPool(ISVNAuthenticationManager manager) {
        if (this.myProject.isDisposed()) {
            throw new ProcessCanceledException();
        }
        return new PrimitivePool(manager, (ISVNTunnelProvider)this.getSvnOptions());
    }

    public SVNUpdateClient createUpdateClient() {
        return this.setupClient(new SVNUpdateClient(this.getPool(), this.getSvnOptions()));
    }

    public SVNUpdateClient createUpdateClient(ISVNAuthenticationManager manager) {
        return SvnKitManager.setupClient(new SVNUpdateClient(this.getPool(manager), this.getSvnOptions()), manager);
    }

    public SVNStatusClient createStatusClient() {
        SVNStatusClient client = new SVNStatusClient(this.getPool(), this.getSvnOptions());
        client.setIgnoreExternals(false);
        return this.setupClient(client);
    }

    public SVNWCClient createWCClient() {
        return this.setupClient(new SVNWCClient(this.getPool(), this.getSvnOptions()));
    }

    public SVNWCClient createWCClient(ISVNAuthenticationManager manager) {
        return SvnKitManager.setupClient(new SVNWCClient(this.getPool(manager), this.getSvnOptions()), manager);
    }

    public SVNCopyClient createCopyClient() {
        return this.setupClient(new SVNCopyClient(this.getPool(), this.getSvnOptions()));
    }

    public SVNMoveClient createMoveClient() {
        return this.setupClient(new SVNMoveClient(this.getPool(), this.getSvnOptions()));
    }

    public SVNLogClient createLogClient() {
        return this.setupClient(new SVNLogClient(this.getPool(), this.getSvnOptions()));
    }

    public SVNLogClient createLogClient(ISVNAuthenticationManager manager) {
        return SvnKitManager.setupClient(new SVNLogClient(this.getPool(manager), this.getSvnOptions()), manager);
    }

    public SVNCommitClient createCommitClient() {
        return this.setupClient(new SVNCommitClient(this.getPool(), this.getSvnOptions()));
    }

    public SVNDiffClient createDiffClient() {
        return this.setupClient(new SVNDiffClient(this.getPool(), this.getSvnOptions()));
    }

    public SVNChangelistClient createChangelistClient() {
        return this.setupClient(new SVNChangelistClient(this.getPool(), this.getSvnOptions()));
    }

    private SvnAuthenticationManager getAuthenticationManager() {
        return this.myConfiguration.getAuthenticationManager(this.myVcs);
    }

    private <T extends SVNBasicClient> T setupClient(T client) {
        return SvnKitManager.setupClient(client, (ISVNAuthenticationManager)this.getAuthenticationManager());
    }

    private static <T extends SVNBasicClient> T setupClient(T client, ISVNAuthenticationManager manager) {
        client.getOperationsFactory().setAuthenticationManager(manager);
        return client;
    }

    static {
        System.setProperty("svnkit.log.native.calls", "true");
        SvnKitDebugLogger logger = new SvnKitDebugLogger(Boolean.getBoolean(LOG_PARAMETER_NAME), Boolean.getBoolean(TRACE_NATIVE_CALLS), LOG);
        SVNDebugLog.setDefaultLog((ISVNDebugLog)logger);
        SVNJNAUtil.setJNAEnabled((boolean)true);
        SvnHttpAuthMethodsDefaultChecker.check();
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SvnKitAdminAreaFactorySelector());
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (SystemInfo.isWindows) {
            SVNAdminArea14.setOptimizedWritingEnabled((boolean)true);
        }
        if (!SVNJNAUtil.isJNAPresent()) {
            LOG.warn("JNA is not found by svnkit library");
        }
        ourExplicitlySetSslProtocols = System.getProperty(SVNKIT_HTTP_SSL_PROTOCOLS);
    }
}

