/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.LoadRecentBranchRevisions;
import org.jetbrains.idea.svn.integrate.MergeCalculatorTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.ShowRecentInDialogTask;

public class MergeAllOrSelectedChooserTask
extends BaseMergeTask {
    public MergeAllOrSelectedChooserTask(MergeContext mergeContext, QuickMergeInteraction interaction) {
        super(mergeContext, interaction, "merge source selector", Where.AWT);
    }

    public void run(ContinuationContext context) {
        switch (this.myInteraction.selectMergeVariant()) {
            case all: {
                context.next(this.getMergeAllTasks());
                break;
            }
            case showLatest: {
                LoadRecentBranchRevisions loader = new LoadRecentBranchRevisions(this.myMergeContext, -1L);
                ShowRecentInDialogTask dialog = new ShowRecentInDialogTask(this.myMergeContext, this.myInteraction, loader);
                context.next(new TaskDescriptor[]{loader, dialog});
                break;
            }
            case select: {
                MergeCalculatorTask calculator = this.getMergeCalculatorTask(context);
                if (calculator == null) break;
                context.next(new TaskDescriptor[]{this.getCalculateFirstCopyPointTask(calculator), calculator});
            }
        }
    }

    private TaskDescriptor getCalculateFirstCopyPointTask(MergeCalculatorTask mergeCalculator) {
        return this.myMergeContext.getVcs().getSvnBranchPointsCalculator().getFirstCopyPointTask(this.myMergeContext.getWcInfo().getRepositoryRoot(), this.myMergeContext.getWcInfo().getRootUrl(), this.myMergeContext.getSourceUrl(), mergeCalculator);
    }

    private MergeCalculatorTask getMergeCalculatorTask(ContinuationContext context) {
        MergeCalculatorTask result = null;
        try {
            result = new MergeCalculatorTask(this.myMergeContext, this.myInteraction);
        }
        catch (VcsException e) {
            this.finishWithError(context, e.getMessage(), true);
        }
        return result;
    }
}

