/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.integrate.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.integrate.LocalChangesPromptTask;
import org.jetbrains.idea.svn.integrate.MergeAllWithBranchCopyPointTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeTask;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.tmatesoft.svn.core.SVNURL;

public abstract class BaseMergeTask
extends TaskDescriptor {
    private static final Logger LOG = Logger.getInstance(BaseMergeTask.class);
    protected final MergeContext myMergeContext;
    protected final QuickMergeInteraction myInteraction;

    public BaseMergeTask(MergeContext mergeContext, QuickMergeInteraction interaction, String name, Where where) {
        super(name, where);
        this.myMergeContext = mergeContext;
        this.myInteraction = interaction;
    }

    protected List<TaskDescriptor> getMergeAllTasks() {
        ArrayList result = ContainerUtil.newArrayList();
        result.add(new LocalChangesPromptTask(this.myMergeContext, this.myInteraction, true, null, null));
        MergeAllWithBranchCopyPointTask mergeAllExecutor = new MergeAllWithBranchCopyPointTask(this.myMergeContext, this.myInteraction);
        result.add(this.myMergeContext.getVcs().getSvnBranchPointsCalculator().getFirstCopyPointTask(this.myMergeContext.getWcInfo().getRepositoryRoot(), this.myMergeContext.getSourceUrl(), this.myMergeContext.getWcInfo().getRootUrl(), mergeAllExecutor));
        result.add(mergeAllExecutor);
        return result;
    }

    protected void runChangeListsMerge(ContinuationContext context, List<CommittedChangeList> lists, SvnBranchPointsCalculator.WrapperInvertor copyPoint, String title) {
        context.next(new TaskDescriptor[]{new LocalChangesPromptTask(this.myMergeContext, this.myInteraction, false, lists, copyPoint), new MergeTask(this.myMergeContext, this.myInteraction, new ChangeListsMergerFactory(lists, false, false, true), title)});
    }

    protected SVNURL parseSourceUrl(ContinuationContext context) {
        SVNURL result = null;
        try {
            result = SvnUtil.createUrl(this.myMergeContext.getSourceUrl());
        }
        catch (SvnBindException e) {
            this.finishWithError(context, e.getMessage(), true);
        }
        return result;
    }

    protected void finishWithError(ContinuationContext context, final String message, final boolean isError) {
        LOG.info((isError ? "Error: " : "Info: ") + message);
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                BaseMergeTask.this.myInteraction.showErrors(message, isError);
                context.cancelEverything();
            }
        }});
    }

    protected void finishWithError(ContinuationContext context, final String message, final List<VcsException> exceptions) {
        BaseMergeTask.log(message, exceptions);
        context.cancelEverything();
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                BaseMergeTask.this.myInteraction.showErrors(message, exceptions);
            }
        }});
    }

    private static void log(String message, List<VcsException> exceptions) {
        if (exceptions != null) {
            for (VcsException exception : exceptions) {
                LOG.info(message, (Throwable)exception);
            }
        }
    }
}

