/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.StandardVersionFilterComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.idea.svn.SvnBundle;

public class SvnVersionFilterComponent
extends StandardVersionFilterComponent<ChangeBrowserSettings> {
    private JCheckBox myUseAuthorFilter;
    private JTextField myAuthorField;
    private JPanel myPanel;
    private JPanel myStandardPanel;
    private JCheckBox myStopOnCopyCheckBox;

    public SvnVersionFilterComponent(boolean showDateFilter) {
        super(showDateFilter);
        this.$$$setupUI$$$();
        this.myStandardPanel.setLayout(new BorderLayout());
        this.myStandardPanel.add(this.getStandardPanel(), "Center");
        this.init(new ChangeBrowserSettings());
    }

    protected void updateAllEnabled(ActionEvent e) {
        super.updateAllEnabled(e);
        SvnVersionFilterComponent.updatePair((JCheckBox)this.myUseAuthorFilter, (JComponent)this.myAuthorField, (ActionEvent)e);
    }

    protected void initValues(ChangeBrowserSettings settings) {
        super.initValues(settings);
        this.myUseAuthorFilter.setSelected(settings.USE_USER_FILTER);
        this.myAuthorField.setText(settings.USER);
        this.myStopOnCopyCheckBox.setSelected(settings.STOP_ON_COPY);
    }

    public void saveValues(ChangeBrowserSettings settings) {
        super.saveValues(settings);
        settings.USER = this.myAuthorField.getText();
        settings.USE_USER_FILTER = this.myUseAuthorFilter.isSelected();
        settings.STOP_ON_COPY = this.myStopOnCopyCheckBox.isSelected();
    }

    protected void installCheckBoxListener(ActionListener filterListener) {
        super.installCheckBoxListener(filterListener);
        this.myUseAuthorFilter.addActionListener(filterListener);
        this.myAuthorField.addActionListener(filterListener);
        this.myStopOnCopyCheckBox.addActionListener(filterListener);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public String getAuthorFilter() {
        if (this.myUseAuthorFilter.isSelected() && this.myAuthorField.getText().length() > 0) {
            return this.myAuthorField.getText();
        }
        return null;
    }

    protected String getChangeNumberTitle() {
        return SvnBundle.message("revision.title", new Object[0]);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseAuthorFilter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.changes.filter.filter.by.author"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAuthorField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myStandardPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myStopOnCopyCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("browse.changes.settings.stop.on.copy"));
        jCheckBox.setSelected(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

