/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchMapperManager;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.integrate.IntegratedSelectedOptionsDialog;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.tmatesoft.svn.core.SVNURL;

public class SvnMergeInfoRootPanelManual {
    private JCheckBox myInclude;
    private TextFieldWithBrowseButton myBranchField;
    private FixedSizeButton myFixedSelectLocal;
    private JPanel myContentPanel;
    private JTextArea myUrlText;
    private JTextArea myLocalArea;
    private JTextArea myMixedRevisions;
    private final Project myProject;
    private final NotNullFunction<WCInfoWithBranches, WCInfoWithBranches> myRefresher;
    private final Runnable myListener;
    private boolean myOnlyOneRoot;
    private WCInfoWithBranches myInfo;
    private final Map<String, String> myBranchToLocal;
    private WCInfoWithBranches.Branch mySelectedBranch;

    public SvnMergeInfoRootPanelManual(Project project, NotNullFunction<WCInfoWithBranches, WCInfoWithBranches> refresher, Runnable listener, boolean onlyOneRoot, WCInfoWithBranches info) {
        this.myOnlyOneRoot = onlyOneRoot;
        this.myInfo = info;
        this.myProject = project;
        this.myRefresher = refresher;
        this.myListener = listener;
        this.myBranchToLocal = ContainerUtil.newHashMap();
        this.init();
        this.myInclude.setVisible(!onlyOneRoot);
        this.initWithData();
    }

    private void initWithData() {
        this.myInclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnMergeInfoRootPanelManual.this.myListener.run();
            }
        });
        this.myUrlText.setText(this.myInfo.getUrl().toString());
        this.myFixedSelectLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SvnMergeInfoRootPanelManual.this.mySelectedBranch != null) {
                    Pair<WorkingCopyInfo, SVNURL> info = IntegratedSelectedOptionsDialog.selectWorkingCopy(SvnMergeInfoRootPanelManual.this.myProject, SvnMergeInfoRootPanelManual.this.myInfo.getUrl(), SvnMergeInfoRootPanelManual.this.mySelectedBranch.getUrl(), false, null, null);
                    if (info != null) {
                        SvnMergeInfoRootPanelManual.this.calculateBranchPathByBranch(SvnMergeInfoRootPanelManual.this.mySelectedBranch.getUrl(), ((WorkingCopyInfo)info.getFirst()).getLocalPath());
                    }
                    SvnMergeInfoRootPanelManual.this.myListener.run();
                }
            }
        });
        this.myBranchField.getTextField().setEditable(false);
        this.myBranchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile vf = SvnUtil.getVirtualFile(SvnMergeInfoRootPanelManual.this.myInfo.getPath());
                if (vf != null) {
                    SelectBranchPopup.show(SvnMergeInfoRootPanelManual.this.myProject, vf, new SelectBranchPopup.BranchSelectedCallback(){

                        @Override
                        public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
                            SvnMergeInfoRootPanelManual.this.refreshSelectedBranch(new WCInfoWithBranches.Branch(url));
                            SvnMergeInfoRootPanelManual.this.calculateBranchPathByBranch(SvnMergeInfoRootPanelManual.this.mySelectedBranch.getUrl(), null);
                            SvnMergeInfoRootPanelManual.this.myListener.run();
                        }
                    }, SvnBundle.message("select.branch.popup.general.title", new Object[0]));
                }
            }
        });
        if (this.myInfo.getBranches().isEmpty()) {
            this.calculateBranchPathByBranch(null, null);
        } else {
            this.refreshSelectedBranch(this.myInfo.getBranches().get(0));
            this.calculateBranchPathByBranch(this.mySelectedBranch.getUrl(), null);
        }
    }

    private void init() {
        this.myContentPanel = new JPanel(new GridBagLayout()){

            @Override
            public void setBounds(Rectangle r) {
                super.setBounds(r);
            }
        };
        this.myContentPanel.setMinimumSize(new Dimension(200, 100));
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0);
        this.myInclude = new JCheckBox();
        gb.fill = 0;
        gb.weightx = 0.0;
        this.myContentPanel.add((Component)this.myInclude, gb);
        JLabel hereLabel = new JLabel("From:");
        ++gb.gridy;
        gb.gridx = 0;
        this.myContentPanel.add((Component)hereLabel, gb);
        this.myUrlText = new JTextArea();
        this.myUrlText.setLineWrap(true);
        this.myUrlText.setBackground(UIUtil.getLabelBackground());
        this.myUrlText.setWrapStyleWord(true);
        gb.weightx = 1.0;
        ++gb.gridx;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myContentPanel.add((Component)this.myUrlText, gb);
        gb.fill = 0;
        JLabel thereLabel = new JLabel("To:");
        gb.weightx = 0.0;
        gb.gridwidth = 1;
        ++gb.gridy;
        gb.gridx = 0;
        this.myContentPanel.add((Component)thereLabel, gb);
        this.myBranchField = new TextFieldWithBrowseButton();
        gb.weightx = 1.0;
        ++gb.gridx;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myContentPanel.add((Component)this.myBranchField, gb);
        gb.gridx = 1;
        ++gb.gridy;
        gb.gridwidth = 1;
        this.myLocalArea = new JTextArea();
        this.myLocalArea.setBackground(UIUtil.getLabelBackground());
        this.myLocalArea.setLineWrap(true);
        this.myLocalArea.setWrapStyleWord(true);
        this.myContentPanel.add((Component)this.myLocalArea, gb);
        ++gb.gridx;
        gb.weightx = 0.0;
        gb.fill = 0;
        this.myFixedSelectLocal = new FixedSizeButton(20);
        this.myContentPanel.add((Component)this.myFixedSelectLocal, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 2;
        this.myMixedRevisions = new JTextArea("Mixed Revision Working Copy");
        this.myMixedRevisions.setForeground((Color)JBColor.RED);
        this.myMixedRevisions.setBackground(this.myContentPanel.getBackground());
        this.myContentPanel.add((Component)this.myMixedRevisions, gb);
        this.myMixedRevisions.setVisible(false);
    }

    public void setMixedRevisions(boolean value) {
        this.myMixedRevisions.setVisible(value);
    }

    private static String getLocal(String url, String localPath) {
        String result = null;
        Set<String> paths = SvnBranchMapperManager.getInstance().get(url);
        if (!ContainerUtil.isEmpty(paths)) {
            result = localPath != null ? (String)ContainerUtil.find(paths, (Object)localPath) : (String)ContainerUtil.getFirstItem((List)ContainerUtil.sorted(paths));
        }
        return result;
    }

    private void calculateBranchPathByBranch(String url, String localPath) {
        String local;
        String string = url == null ? null : (local = SvnMergeInfoRootPanelManual.getLocal(url, localPath == null ? this.myBranchToLocal.get(url) : localPath));
        if (local == null) {
            this.myLocalArea.setForeground((Color)JBColor.RED);
            this.myLocalArea.setText(SvnBundle.message("tab.repository.merge.panel.root.panel.select.local", new Object[0]));
        } else {
            this.myLocalArea.setForeground(UIUtil.getInactiveTextColor());
            this.myLocalArea.setText(local);
            this.myBranchToLocal.put(url, local);
        }
    }

    private void refreshSelectedBranch(WCInfoWithBranches.Branch branch) {
        this.myBranchField.setText(branch.getName());
        if (!this.initSelectedBranch(branch)) {
            this.myInfo = (WCInfoWithBranches)this.myRefresher.fun((Object)this.myInfo);
            this.initSelectedBranch(branch);
        }
    }

    private boolean initSelectedBranch(WCInfoWithBranches.Branch branch) {
        boolean found = this.myInfo.getBranches().contains(branch);
        if (found) {
            this.mySelectedBranch = branch;
        }
        return found;
    }

    public void setOnlyOneRoot(boolean onlyOneRoot) {
        this.myOnlyOneRoot = onlyOneRoot;
        this.myInclude.setEnabled(!this.myOnlyOneRoot);
        this.myInclude.setSelected(true);
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    private void createUIComponents() {
        this.myFixedSelectLocal = new FixedSizeButton(20);
    }

    public InfoHolder getInfo() {
        return new InfoHolder(this.mySelectedBranch, this.getLocalBranch(), this.myInclude.isSelected());
    }

    public void initSelection(InfoHolder holder) {
        this.myInclude.setSelected(holder.isEnabled());
        if (holder.getBranch() != null) {
            this.refreshSelectedBranch(holder.getBranch());
            this.calculateBranchPathByBranch(this.mySelectedBranch.getUrl(), holder.getLocal());
        }
    }

    public WCInfoWithBranches getWcInfo() {
        return this.myInfo;
    }

    public WCInfoWithBranches.Branch getBranch() {
        return this.mySelectedBranch;
    }

    public String getLocalBranch() {
        return this.mySelectedBranch != null ? this.myBranchToLocal.get(this.mySelectedBranch.getUrl()) : null;
    }

    public boolean isEnabled() {
        return this.myOnlyOneRoot || this.myInclude.isSelected();
    }

    public static class InfoHolder {
        private final WCInfoWithBranches.Branch myBranch;
        private final String myLocal;
        private final boolean myEnabled;

        public InfoHolder(WCInfoWithBranches.Branch branch, String local, boolean enabled) {
            this.myBranch = branch;
            this.myLocal = local;
            this.myEnabled = enabled;
        }

        public WCInfoWithBranches.Branch getBranch() {
            return this.myBranch;
        }

        public String getLocal() {
            return this.myLocal;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }
    }
}

