/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.idea.svn.properties.PropertyData;

public class SvnPropertiesDiffRequest
extends ContentDiffRequest {
    private final List<DiffContent> myContents;
    private final List<String> myContentTitles;
    private final String myWindowTitle;

    public SvnPropertiesDiffRequest(String windowTitle, DiffContent content1, DiffContent content2, String title1, String title2) {
        this.myWindowTitle = windowTitle;
        this.myContents = ContainerUtil.list((Object[])new DiffContent[]{content1, content2});
        this.myContentTitles = ContainerUtil.list((Object[])new String[]{title1, title2});
        assert (content1 instanceof PropertyContent || content1 instanceof EmptyContent);
        assert (content2 instanceof PropertyContent || content2 instanceof EmptyContent);
        assert (content1 instanceof PropertyContent || content2 instanceof PropertyContent);
    }

    public SvnPropertiesDiffRequest(List<PropertyData> before, List<PropertyData> after, String title1, String title2) {
        assert (before != null || after != null);
        this.myContents = ContainerUtil.list((Object[])new DiffContent[]{this.createContent(before), this.createContent(after)});
        this.myWindowTitle = "Svn Properties Diff";
        this.myContentTitles = ContainerUtil.list((Object[])new String[]{title1, title2});
    }

    public DiffContent createContent(List<PropertyData> content) {
        if (content == null) {
            return new EmptyContent();
        }
        return new PropertyContent(content);
    }

    public String getTitle() {
        return this.myWindowTitle;
    }

    public List<String> getContentTitles() {
        return this.myContentTitles;
    }

    public List<DiffContent> getContents() {
        return this.myContents;
    }

    public static class PropertyContent
    implements DiffContent {
        private final List<PropertyData> myProperties;

        public PropertyContent(List<PropertyData> properties) {
            this.myProperties = properties;
        }

        public List<PropertyData> getProperties() {
            return this.myProperties;
        }

        public FileType getContentType() {
            return null;
        }

        public OpenFileDescriptor getOpenFileDescriptor() {
            return null;
        }

        public void onAssigned(boolean isAssigned) {
        }
    }
}

