/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import javax.swing.Action;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;

public class CheckoutDialog
extends RepositoryBrowserDialog {
    private final CheckoutProvider.Listener myListener;

    public CheckoutDialog(Project project, CheckoutProvider.Listener listener) {
        super(project, false, null);
        this.myListener = listener;
    }

    public void init() {
        super.init();
        this.setTitle(SvnBundle.message("checkout.dialog.title", new Object[0]));
        this.setOKButtonText(SvnBundle.message("checkout.dialog.button", new Object[0]));
        this.getRepositoryBrowser().addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (CheckoutDialog.this.getOKAction() != null) {
                    CheckoutDialog.this.getOKAction().setEnabled(CheckoutDialog.this.getRepositoryBrowser().getSelectedURL() != null);
                }
            }
        });
        this.getOKAction().setEnabled(this.getRepositoryBrowser().getSelectedURL() != null);
    }

    @Override
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    @Override
    protected String getHelpId() {
        return "vcs.subversion.browseSVN";
    }

    protected void doOKAction() {
        RepositoryTreeNode selectedNode = this.getSelectedNode();
        this.close(0);
        this.doCheckout(this.myListener, selectedNode);
    }
}

