/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;

public class ConflictVersion
extends BaseNodeDescription {
    private final SVNURL myRepositoryRoot;
    private final String myPath;
    private final long myPegRevision;

    public static ConflictVersion create(SVNConflictVersion conflictVersion) {
        ConflictVersion result = null;
        if (conflictVersion != null) {
            result = new ConflictVersion(conflictVersion.getRepositoryRoot(), conflictVersion.getPath(), conflictVersion.getPegRevision(), NodeKind.from(conflictVersion.getKind()));
        }
        return result;
    }

    public ConflictVersion(SVNURL repositoryRoot, String path, long pegRevision, NodeKind kind) {
        super(kind);
        this.myRepositoryRoot = repositoryRoot;
        this.myPath = path;
        this.myPegRevision = pegRevision;
    }

    public SVNURL getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getPath() {
        return this.myPath;
    }

    public long getPegRevision() {
        return this.myPegRevision;
    }

    public NodeKind getKind() {
        return this.myKind;
    }

    public String toPresentableString() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.myRepositoryRoot != null ? this.myRepositoryRoot : "");
        urlBuilder.append("/");
        urlBuilder.append(this.myPath != null ? this.myPath : "...");
        return "(" + (Object)((Object)this.getKind()) + ") " + urlBuilder + "@" + this.getPegRevision();
    }

    public static String toPresentableString(ConflictVersion version) {
        return version == null ? "" : version.toPresentableString();
    }
}

