/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;

public enum ConflictAction {
    EDIT("edit", "edited"),
    ADD("add", "added"),
    DELETE("delete", "deleted"),
    REPLACE("replace", "replaced");

    private static final Map<String, ConflictAction> ourAllActions;
    private final String myKey;
    private final String[] myOtherKeys;

    private ConflictAction(String key, String ... otherKeys) {
        this.myKey = key;
        this.myOtherKeys = otherKeys;
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(ConflictAction action) {
        ourAllActions.put(action.myKey, action);
        for (String otherKey : action.myOtherKeys) {
            ourAllActions.put(otherKey, action);
        }
    }

    public static ConflictAction from(String actionName) {
        ConflictAction result = ourAllActions.get(actionName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown conflict action " + actionName);
        }
        return result;
    }

    static {
        ourAllActions = ContainerUtil.newHashMap();
        for (ConflictAction action : ConflictAction.values()) {
            ConflictAction.register(action);
        }
    }
}

