/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.CertificateCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;

public class UsernamePasswordCallback
extends AuthCallbackCase {
    private static final String COULD_NOT_AUTHENTICATE_TO_SERVER_MESSAGE = "could not authenticate to server";
    private static final String UNABLE_TO_CONNECT_MESSAGE = "Unable to connect to a repository";
    private static final String AUTHENTICATION_FAILED_MESSAGE = "Authentication failed";
    private static final String INVALID_CREDENTIALS_FOR_SVN_PROTOCOL = "svn: E170001: Can't get";
    private static final String PASSWORD_STRING = "password";
    private static final Pattern UNABLE_TO_CONNECT_TO_URL_PATTERN = Pattern.compile("Unable to connect to a repository at URL '(.*)'");
    protected SVNAuthentication myAuthentication;

    UsernamePasswordCallback(AuthenticationService authenticationService, SVNURL url) {
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        boolean useSvnKit = Registry.is((String)"svn.use.svnkit.for.https.server.certificate.check");
        return error.contains(AUTHENTICATION_FAILED_MESSAGE) || error.contains(INVALID_CREDENTIALS_FOR_SVN_PROTOCOL) && error.contains(PASSWORD_STRING) || error.contains(UNABLE_TO_CONNECT_MESSAGE) && (useSvnKit || !CertificateCallbackCase.isCertificateVerificationFailed(error)) || StringUtil.containsIgnoreCase((String)error, (String)COULD_NOT_AUTHENTICATE_TO_SERVER_MESSAGE);
    }

    @Override
    boolean getCredentials(String errText) throws SvnBindException {
        this.myAuthentication = this.myAuthenticationService.requestCredentials(this.myUrl != null ? this.myUrl : this.parseUrlFromError(errText), this.getType());
        return this.myAuthentication != null;
    }

    public String getType() {
        return "svn.simple";
    }

    @Override
    public void updateParameters(Command command) {
        if (this.myAuthentication instanceof SVNPasswordAuthentication) {
            SVNPasswordAuthentication auth = (SVNPasswordAuthentication)this.myAuthentication;
            command.put("--username");
            command.put(auth.getUserName());
            command.put("--password");
            command.put(auth.getPassword());
            if (!auth.isStorageAllowed()) {
                command.put("--no-auth-cache");
            }
        }
    }

    private SVNURL parseUrlFromError(String errorText) {
        Matcher matcher = UNABLE_TO_CONNECT_TO_URL_PATTERN.matcher(errorText);
        String urlValue = null;
        if (matcher.find()) {
            urlValue = matcher.group(1);
        }
        return urlValue != null ? this.parseUrl(urlValue) : null;
    }
}

