/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class SshTunnelRuntimeModule
extends BaseCommandRuntimeModule {
    public static final String DEFAULT_SSH_TUNNEL_VALUE = "$SVN_SSH ssh -q";

    public SshTunnelRuntimeModule(CommandRuntime runtime) {
        super(runtime);
    }

    @Override
    public void onStart(Command command) throws SvnBindException {
        if (!CommandRuntime.isLocal(command) && !SvnConfiguration.SshConnectionType.SUBVERSION_CONFIG.equals((Object)this.getState().sshConnectionType)) {
            command.put("--config-option", "config:tunnels:ssh=" + StringUtil.notNullize((String)this.buildTunnelValue()));
        }
    }

    private SvnConfiguration getConfiguration() {
        return this.myRuntime.getVcs().getSvnConfiguration();
    }

    private SvnConfigurationState getState() {
        return this.getConfiguration().getState();
    }

    private String buildTunnelValue() {
        String sshPath = this.getState().sshExecutablePath;
        sshPath = !StringUtil.isEmpty((String)sshPath) ? sshPath : SshTunnelRuntimeModule.getExecutablePath(this.getConfiguration().getSshTunnelSetting());
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)sshPath, (List)this.buildTunnelCommandLine(sshPath).getParametersList().getParameters()), (String)" ");
    }

    private GeneralCommandLine buildTunnelCommandLine(String sshPath) {
        GeneralCommandLine result = new GeneralCommandLine(new String[]{sshPath});
        boolean isPuttyLinkClient = StringUtil.endsWithIgnoreCase((String)FileUtil.getNameWithoutExtension((String)sshPath), (String)"plink");
        SvnConfigurationState state = this.getState();
        if (!isPuttyLinkClient) {
            result.addParameter("-q");
        }
        result.addParameters(new String[]{isPuttyLinkClient ? "-P" : "-p", String.valueOf(state.sshPort)});
        if (!StringUtil.isEmpty((String)state.sshUserName)) {
            result.addParameters(new String[]{"-l", state.sshUserName});
        }
        if (SvnConfiguration.SshConnectionType.PRIVATE_KEY.equals((Object)state.sshConnectionType) && !StringUtil.isEmpty((String)state.sshPrivateKeyPath)) {
            result.addParameters(new String[]{"-i", FileUtil.toSystemIndependentName((String)state.sshPrivateKeyPath)});
        }
        return result;
    }

    public static String getSshTunnelValue(String tunnelSetting) {
        String svnSshVariableName = SshTunnelRuntimeModule.getSvnSshVariableName(tunnelSetting = !StringUtil.isEmpty((String)tunnelSetting) ? tunnelSetting : DEFAULT_SSH_TUNNEL_VALUE);
        String svnSshVariableValue = EnvironmentUtil.getValue((String)svnSshVariableName);
        return !StringUtil.isEmpty((String)svnSshVariableValue) ? svnSshVariableValue : (!StringUtil.isEmpty((String)svnSshVariableName) ? tunnelSetting.substring(1 + svnSshVariableName.length()) : tunnelSetting);
    }

    public static String getSvnSshVariableName(String tunnel) {
        String result = "";
        if (tunnel != null && tunnel.startsWith("$")) {
            result = ((String)ObjectUtils.notNull((Object)StringUtil.substringBefore((String)tunnel, (String)" "), (Object)tunnel)).substring(1);
        }
        return result;
    }

    public static String getExecutablePath(String tunnelSetting) {
        return StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)ParametersListUtil.parse((String)SshTunnelRuntimeModule.getSshTunnelValue(tunnelSetting))))).trim();
    }
}

