/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.LineHandlerHelper;
import java.util.Iterator;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;

public class ResultBuilderNotifier
extends ProcessAdapter {
    private final StringBuilder myStdoutLine = new StringBuilder();
    private final StringBuilder myStderrLine = new StringBuilder();
    private final LineCommandListener myResultBuilder;

    public ResultBuilderNotifier(LineCommandListener resultBuilder) {
        this.myResultBuilder = resultBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTerminated(ProcessEvent event) {
        try {
            this.forceNewLine();
        }
        finally {
            this.myResultBuilder.processTerminated(event.getExitCode());
        }
    }

    private void forceNewLine() {
        if (this.myStdoutLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDOUT);
        } else if (this.myStderrLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDERR);
        }
    }

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        this.onTextAvailable(event.getText(), outputType);
    }

    private void onTextAvailable(String text, Key outputType) {
        Iterator<String> lines = LineHandlerHelper.splitText((String)text).iterator();
        if (ProcessOutputTypes.STDOUT == outputType) {
            this.notifyLines(outputType, lines, this.myStdoutLine);
        } else if (ProcessOutputTypes.STDERR == outputType) {
            this.notifyLines(outputType, lines, this.myStderrLine);
        }
    }

    private void notifyLines(Key outputType, Iterator<String> lines, StringBuilder lineBuilder) {
        block5: {
            String line;
            if (!lines.hasNext()) {
                return;
            }
            if (lineBuilder.length() > 0) {
                lineBuilder.append(lines.next());
                if (lines.hasNext()) {
                    line = lineBuilder.toString();
                    this.notifyLine(line, outputType);
                    lineBuilder.setLength(0);
                }
            }
            while (true) {
                line = null;
                if (lines.hasNext()) {
                    line = lines.next();
                }
                if (!lines.hasNext()) break;
                this.notifyLine(line, outputType);
            }
            if (line == null || line.length() <= 0) break block5;
            lineBuilder.append(line);
        }
    }

    private void notifyLine(String line, Key outputType) {
        this.myResultBuilder.onLineAvailable(LineHandlerHelper.trimLineSeparator((String)line), outputType);
    }
}

