/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class Command {
    private final List<String> myParameters = ContainerUtil.newArrayList();
    private final List<String> myOriginalParameters = ContainerUtil.newArrayList();
    private final SvnCommandName myName;
    private File workingDirectory;
    private File myConfigDir;
    private LineCommandListener myResultBuilder;
    private volatile SVNURL myRepositoryUrl;
    private SvnTarget myTarget;
    private Collection<File> myTargets;
    private PropertyValue myPropertyValue;
    private ProgressTracker myCanceller;

    public Command(SvnCommandName name) {
        this.myName = name;
    }

    public void put(Depth depth) {
        CommandUtil.put(this.myParameters, depth, false);
    }

    public void put(SvnTarget target) {
        CommandUtil.put(this.myParameters, target);
    }

    public void put(SVNRevision revision) {
        CommandUtil.put(this.myParameters, revision);
    }

    public void put(String parameter, boolean condition) {
        CommandUtil.put(this.myParameters, condition, parameter);
    }

    public void put(String ... parameters) {
        this.put(Arrays.asList(parameters));
    }

    public void put(List<String> parameters) {
        this.myParameters.addAll(parameters);
    }

    public void putIfNotPresent(String parameter) {
        if (!this.myParameters.contains(parameter)) {
            this.myParameters.add(parameter);
        }
    }

    public ProgressTracker getCanceller() {
        return this.myCanceller;
    }

    public void setCanceller(ProgressTracker canceller) {
        this.myCanceller = canceller;
    }

    public File getConfigDir() {
        return this.myConfigDir;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public LineCommandListener getResultBuilder() {
        return this.myResultBuilder;
    }

    public SVNURL getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    public SVNURL requireRepositoryUrl() {
        SVNURL result = this.getRepositoryUrl();
        assert (result != null);
        return result;
    }

    public SvnTarget getTarget() {
        return this.myTarget;
    }

    public List<String> getTargetsPaths() {
        return ContainerUtil.isEmpty(this.myTargets) ? null : ContainerUtil.map(this.myTargets, (Function)new Function<File, String>(){

            public String fun(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    public PropertyValue getPropertyValue() {
        return this.myPropertyValue;
    }

    public SvnCommandName getName() {
        return this.myName;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setConfigDir(File configDir) {
        this.myConfigDir = configDir;
    }

    public void setResultBuilder(LineCommandListener resultBuilder) {
        this.myResultBuilder = resultBuilder;
    }

    public void setRepositoryUrl(SVNURL repositoryUrl) {
        this.myRepositoryUrl = repositoryUrl;
    }

    public void setTarget(SvnTarget target) {
        this.myTarget = target;
    }

    public void setTargets(Collection<File> targets) {
        this.myTargets = targets;
    }

    public void setPropertyValue(PropertyValue propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public void saveOriginalParameters() {
        this.myOriginalParameters.clear();
        this.myOriginalParameters.addAll(this.myParameters);
    }

    public List<String> getParameters() {
        return ContainerUtil.newArrayList(this.myParameters);
    }

    public String getText() {
        ArrayList<String> data = new ArrayList<String>();
        if (this.myConfigDir != null) {
            data.add("--config-dir");
            data.add(this.myConfigDir.getPath());
        }
        data.add(this.myName.getName());
        data.addAll(this.myOriginalParameters);
        List<String> targetsPaths = this.getTargetsPaths();
        if (!ContainerUtil.isEmpty(targetsPaths)) {
            data.addAll(targetsPaths);
        }
        return StringUtil.join(data, (String)" ");
    }

    public boolean isLocalInfo() {
        return this.is(SvnCommandName.info) && this.hasLocalTarget() && !this.myParameters.contains("--revision");
    }

    public boolean isLocalStatus() {
        return this.is(SvnCommandName.st) && this.hasLocalTarget() && !this.myParameters.contains("-u");
    }

    public boolean isLocalProperty() {
        boolean isPropertyCommand = this.is(SvnCommandName.proplist) || this.is(SvnCommandName.propget) || this.is(SvnCommandName.propset) || this.is(SvnCommandName.propdel);
        return isPropertyCommand && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    public boolean isLocalCat() {
        return this.is(SvnCommandName.cat) && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    private SVNRevision getRevision() {
        int index = this.myParameters.indexOf("--revision");
        return index >= 0 && index + 1 < this.myParameters.size() ? SVNRevision.parse((String)this.myParameters.get(index + 1)) : null;
    }

    public boolean is(SvnCommandName name) {
        return name.equals((Object)this.myName);
    }

    private boolean hasLocalTarget() {
        return this.myTarget.isFile() && Command.isLocal(this.myTarget.getPegRevision());
    }

    private static boolean isLocal(SVNRevision revision) {
        return revision == null || SVNRevision.UNDEFINED.equals((Object)revision) || SVNRevision.BASE.equals((Object)revision) || SVNRevision.WORKING.equals((Object)revision);
    }
}

