/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManagerQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.BranchesLoader;
import org.jetbrains.idea.svn.branchConfig.DefaultBranchConfigInitializer;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class NewRootBunch {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.NewRootBunch");
    private final Object myLock = new Object();
    private final Project myProject;
    private final ProgressManagerQueue myBranchesLoader;
    private final Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> myMap;

    public NewRootBunch(Project project, ProgressManagerQueue branchesLoader) {
        this.myProject = project;
        this.myBranchesLoader = branchesLoader;
        this.myMap = new HashMap<VirtualFile, InfoStorage<SvnBranchConfigurationNew>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForRoot(final VirtualFile root, final InfoStorage<SvnBranchConfigurationNew> config, boolean reload) {
        Object object = this.myLock;
        synchronized (object) {
            boolean override;
            SvnBranchConfigurationNew previous;
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                previous = null;
                override = true;
                this.myMap.put(root, config);
            } else {
                previous = existing.getValue();
                override = existing.accept(config);
            }
            if (reload && override) {
                this.myBranchesLoader.run((Object)new Runnable(){

                    @Override
                    public void run() {
                        NewRootBunch.this.reloadBranches(root, previous, (SvnBranchConfigurationNew)config.getValue());
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBranches(VirtualFile root, String branchesParent, InfoStorage<List<SvnBranchItem>> items) {
        Object object = this.myLock;
        synchronized (object) {
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                LOG.info("cannot update branches, branches parent not found: " + branchesParent);
            } else {
                existing.getValue().updateBranch(branchesParent, items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnBranchConfigurationNew getConfig(VirtualFile root) {
        Object object = this.myLock;
        synchronized (object) {
            SvnBranchConfigurationNew result;
            InfoStorage<SvnBranchConfigurationNew> value = this.myMap.get(root);
            if (value == null) {
                result = new SvnBranchConfigurationNew();
                this.myMap.put(root, new InfoStorage<SvnBranchConfigurationNew>(result, InfoReliability.empty));
                this.myBranchesLoader.run((Object)new DefaultBranchConfigInitializer(this.myProject, this, root));
            } else {
                result = value.getValue();
            }
            return result;
        }
    }

    public void reloadBranchesAsync(final VirtualFile root, final String branchLocation, final InfoReliability reliability) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                NewRootBunch.this.reloadBranches(root, branchLocation, reliability, true);
            }
        });
    }

    public void reloadBranches(VirtualFile root, SvnBranchConfigurationNew prev, SvnBranchConfigurationNew next) {
        HashSet<String> oldUrls = prev == null ? Collections.emptySet() : new HashSet<String>(prev.getBranchUrls());
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
            return;
        }
        for (String newBranchUrl : next.getBranchUrls()) {
            if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
                return;
            }
            if (oldUrls.contains(newBranchUrl)) continue;
            this.reloadBranches(root, newBranchUrl, InfoReliability.defaultValues, true);
        }
    }

    public void reloadBranches(VirtualFile root, String branchLocation, InfoReliability reliability, boolean passive) {
        new BranchesLoader(this.myProject, this, branchLocation, reliability, root, passive).run();
    }

    public SVNURL getWorkingBranch(SVNURL svnurl, VirtualFile root) {
        SVNURL result;
        try {
            result = this.myMap.get(root).getValue().getWorkingBranch(svnurl);
        }
        catch (SvnBindException e) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<VirtualFile, SvnBranchConfigurationNew> getMapCopy() {
        Object object = this.myLock;
        synchronized (object) {
            HashMap<VirtualFile, SvnBranchConfigurationNew> result = new HashMap<VirtualFile, SvnBranchConfigurationNew>();
            for (VirtualFile vf : this.myMap.keySet()) {
                result.put(vf, this.myMap.get(vf).getValue());
            }
            return result;
        }
    }
}

