/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ClientOnlyTrustManager;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.tmatesoft.svn.core.SVNURL;

public class CertificateTrustManager
extends ClientOnlyTrustManager {
    private static final Logger LOG = Logger.getInstance(CertificateTrustManager.class);
    private final AuthenticationService myAuthenticationService;
    private final SVNURL myRepositoryUrl;
    private final String myRealm;

    public CertificateTrustManager(AuthenticationService authenticationService, SVNURL repositoryUrl) {
        this.myAuthenticationService = authenticationService;
        this.myRepositoryUrl = repositoryUrl;
        this.myRealm = new URIBuilder().setScheme(repositoryUrl.getProtocol()).setHost(repositoryUrl.getHost()).setPort(repositoryUrl.getPort()).toString();
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate certificate;
        if (chain != null && chain.length > 0 && chain[0] != null && !this.checkPassive(certificate = chain[0])) {
            if (!CertificateTrustManager.isAcceptedByIdea(chain, authType)) {
                this.checkActive(certificate);
            }
            this.acknowledge(certificate);
        }
    }

    private boolean checkPassive(X509Certificate certificate) throws CertificateEncodingException {
        Object cachedData = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck("svn.ssl.server", this.myRealm);
        return certificate.equals(cachedData);
    }

    private static boolean isAcceptedByIdea(X509Certificate[] chain, String authType) {
        boolean result;
        try {
            CertificateManager.getInstance().getTrustManager().checkServerTrusted(chain, authType, false, false);
            result = true;
        }
        catch (CertificateException e) {
            LOG.debug((Throwable)e);
            result = false;
        }
        return result;
    }

    private void checkActive(X509Certificate certificate) throws CertificateException {
        boolean isStorageEnabled = this.myAuthenticationService.getAuthenticationManager().getHostOptionsProvider().getHostOptions(this.myRepositoryUrl).isAuthStorageEnabled();
        int result = this.myAuthenticationService.getAuthenticationManager().getInnerProvider().acceptServerAuthentication(this.myRepositoryUrl, this.myRealm, (Object)certificate, isStorageEnabled);
        switch (result) {
            case 1: 
            case 2: {
                break;
            }
            case 0: {
                throw new CertificateException("Server SSL certificate rejected");
            }
        }
    }

    private void acknowledge(X509Certificate certificate) throws CertificateEncodingException {
        this.myAuthenticationService.getVcs().getSvnConfiguration().acknowledge("cmd.ssl.server", this.myRealm, certificate);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return CertificateManager.getInstance().getTrustManager().getAcceptedIssuers();
    }
}

