/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import org.tmatesoft.svn.core.SVNNodeKind;

@XmlEnum
public enum NodeKind {
    UNKNOWN("unknown"),
    FILE("file"),
    DIR("dir"),
    NONE("none");

    private static final Map<String, NodeKind> ourAllNodeKinds;
    private final String myKey;

    private NodeKind(String key) {
        this.myKey = key;
    }

    public boolean isFile() {
        return FILE.equals((Object)this);
    }

    public boolean isDirectory() {
        return DIR.equals((Object)this);
    }

    public boolean isNone() {
        return NONE.equals((Object)this);
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(NodeKind kind) {
        ourAllNodeKinds.put(kind.myKey, kind);
    }

    public static NodeKind from(String nodeKindName) {
        NodeKind result = ourAllNodeKinds.get(nodeKindName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown node kind " + nodeKindName);
        }
        return result;
    }

    public static NodeKind from(SVNNodeKind nodeKind) {
        return NodeKind.from(nodeKind.toString());
    }

    public static NodeKind from(boolean isDirectory) {
        return isDirectory ? DIR : FILE;
    }

    static {
        ourAllNodeKinds = ContainerUtil.newHashMap();
        for (NodeKind kind : NodeKind.values()) {
            NodeKind.register(kind);
        }
    }
}

