/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Date;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.annotate.AnnotationConsumer;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitAnnotateClient
extends BaseSvnClient
implements AnnotateClient {
    @Override
    public void annotate(SvnTarget target, SVNRevision startRevision, SVNRevision endRevision, boolean includeMergedRevisions, DiffOptions diffOptions, AnnotationConsumer handler) throws VcsException {
        try {
            SVNLogClient client = this.myVcs.getSvnKitManager().createLogClient();
            client.setDiffOptions(SvnKitAnnotateClient.toDiffOptions(diffOptions));
            if (target.isFile()) {
                client.doAnnotate(target.getFile(), target.getPegRevision(), startRevision, endRevision, true, includeMergedRevisions, SvnKitAnnotateClient.toAnnotateHandler(handler), null);
            } else {
                client.doAnnotate(target.getURL(), target.getPegRevision(), startRevision, endRevision, true, includeMergedRevisions, SvnKitAnnotateClient.toAnnotateHandler(handler), null);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static ISVNAnnotateHandler toAnnotateHandler(final AnnotationConsumer handler) {
        ISVNAnnotateHandler result = null;
        if (handler != null) {
            result = new ISVNAnnotateHandler(){

                public void handleLine(Date date, long revision, String author, String line) throws SVNException {
                }

                public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
                    if (revision > 0L) {
                        CommitInfo info = new CommitInfo.Builder(revision, date, author).build();
                        CommitInfo mergeInfo = mergedDate != null ? new CommitInfo.Builder(mergedRevision, mergedDate, mergedAuthor).build() : null;
                        handler.consume(lineNumber, info, mergeInfo);
                    }
                }

                public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
                    return false;
                }

                public void handleEOF() throws SVNException {
                }
            };
        }
        return result;
    }
}

