/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.UriUtil;
import java.io.File;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNURL;

public class RootUrlInfo
implements RootUrlPair {
    private final String myRepositoryUrl;
    private final WorkingCopyFormat myFormat;
    private final Node myNode;
    private final VirtualFile myRoot;
    private volatile NestedCopyType myType;

    public RootUrlInfo(Node node, WorkingCopyFormat format, VirtualFile root) {
        this(node, format, root, null);
    }

    public RootUrlInfo(Node node, WorkingCopyFormat format, VirtualFile root, NestedCopyType type) {
        this.myNode = node;
        this.myFormat = format;
        this.myRoot = root;
        this.myRepositoryUrl = UriUtil.trimTrailingSlashes((String)node.getRepositoryRootUrl().toString());
        this.myType = type;
    }

    public Node getNode() {
        return this.myNode;
    }

    public String getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    public SVNURL getRepositoryUrlUrl() {
        return this.myNode.getRepositoryRootUrl();
    }

    public String getAbsoluteUrl() {
        return this.getAbsoluteUrlAsUrl().toString();
    }

    public SVNURL getAbsoluteUrlAsUrl() {
        return this.myNode.getUrl();
    }

    public WorkingCopyFormat getFormat() {
        return this.myFormat;
    }

    public File getIoFile() {
        return this.myNode.getIoFile();
    }

    public String getPath() {
        return this.getIoFile().getAbsolutePath();
    }

    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myNode.getFile();
    }

    @Override
    public String getUrl() {
        return this.getAbsoluteUrl();
    }

    public NestedCopyType getType() {
        return this.myType;
    }

    public void setType(NestedCopyType type) {
        this.myType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootUrlInfo info = (RootUrlInfo)o;
        if (this.myFormat != info.myFormat) {
            return false;
        }
        if (!this.myNode.equals(info.myNode)) {
            return false;
        }
        if (!this.myRoot.equals(info.myRoot)) {
            return false;
        }
        return this.myType == info.myType;
    }

    public int hashCode() {
        int result = this.myFormat.hashCode();
        result = 31 * result + this.myNode.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }
}

