/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest;

import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.JiraTask;
import com.intellij.tasks.jira.rest.model.JiraComment;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Date;

public class JiraRestTask
extends JiraTask {
    private final JiraIssue myJiraIssue;

    public JiraRestTask(JiraIssue jiraIssue, TaskRepository repository) {
        super(repository);
        this.myJiraIssue = jiraIssue;
    }

    @Override
    public String getId() {
        return this.myJiraIssue.getKey();
    }

    @Override
    public String getSummary() {
        return this.myJiraIssue.getSummary();
    }

    @Override
    public String getDescription() {
        return this.myJiraIssue.getDescription();
    }

    @Override
    public Comment[] getComments() {
        return (Comment[])ContainerUtil.map2Array(this.myJiraIssue.getComments(), Comment.class, (Function)new Function<JiraComment, Comment>(){

            public Comment fun(final JiraComment comment) {
                return new Comment(){

                    public String getText() {
                        return comment.getBody();
                    }

                    public String getAuthor() {
                        return comment.getAuthor().getDisplayName();
                    }

                    public Date getDate() {
                        return comment.getCreated();
                    }

                    public String toString() {
                        return comment.getAuthor().getDisplayName();
                    }
                };
            }
        });
    }

    @Override
    protected String getIconUrl() {
        return this.myJiraIssue.getIssueType().getIconUrl();
    }

    @Override
    public TaskType getType() {
        return this.getTypeByName(this.myJiraIssue.getIssueType().getName());
    }

    @Override
    public TaskState getState() {
        return this.getStateById(Integer.parseInt(this.myJiraIssue.getStatus().getId()));
    }

    @Override
    public Date getUpdated() {
        return this.myJiraIssue.getUpdated();
    }

    @Override
    public Date getCreated() {
        return this.myJiraIssue.getCreated();
    }

    public JiraIssue getJiraIssue() {
        return this.myJiraIssue;
    }
}

