/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tasks.jira.jql.JqlElementType;
import com.intellij.tasks.jira.jql.JqlLanguage;
import com.intellij.tasks.jira.jql.JqlTokenTypes;
import com.intellij.tasks.jira.jql.psi.impl.JqlAndClauseImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlArgumentListImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlChangedClauseImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlEmptyValueImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlFunctionCallImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlHistoryPredicateImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlIdentifierImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlListImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlLiteralImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlNotClauseImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlOrClauseImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlOrderByImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlQueryImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlSimpleClauseImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlSortKeyImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlSubClauseImpl;
import com.intellij.tasks.jira.jql.psi.impl.JqlWasClauseImpl;

public interface JqlElementTypes {
    public static final IFileElementType FILE = new IFileElementType((Language)JqlLanguage.INSTANCE);
    public static final IElementType QUERY = new JqlElementType("QUERY");
    public static final IElementType OR_CLAUSE = new JqlElementType("OR_CLAUSE");
    public static final IElementType AND_CLAUSE = new JqlElementType("AND_CLAUSE");
    public static final IElementType NOT_CLAUSE = new JqlElementType("NOT_CLAUSE");
    public static final IElementType SUB_CLAUSE = new JqlElementType("SUB_CLAUSE");
    public static final IElementType SIMPLE_CLAUSE = new JqlElementType("SIMPLE_CLAUSE");
    public static final IElementType WAS_CLAUSE = new JqlElementType("WAS_CLAUSE");
    public static final IElementType CHANGED_CLAUSE = new JqlElementType("CHANGED_CLAUSE");
    public static final IElementType LIST = new JqlElementType("LIST");
    public static final IElementType ORDER_BY = new JqlElementType("ORDER_BY");
    public static final IElementType IDENTIFIER = new JqlElementType("IDENTIFIER");
    public static final IElementType LITERAL = new JqlElementType("LITERAL");
    public static final IElementType FUNCTION_CALL = new JqlElementType("FUNCTION_CALL");
    public static final IElementType ARGUMENT_LIST = new JqlElementType("ARGUMENT_LIST");
    public static final IElementType SORT_KEY = new JqlElementType("SORT_KEY");
    public static final IElementType EMPTY = new JqlElementType("EMPTY");
    public static final IElementType HISTORY_PREDICATE = new JqlElementType("HISTORY_PREDICATE");
    public static final TokenSet OPERAND_NODES = TokenSet.create((IElementType[])new IElementType[]{JqlTokenTypes.NUMBER_LITERAL, JqlTokenTypes.STRING_LITERAL, LIST, FUNCTION_CALL, EMPTY});

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == QUERY) {
                return new JqlQueryImpl(node);
            }
            if (type == OR_CLAUSE) {
                return new JqlOrClauseImpl(node);
            }
            if (type == AND_CLAUSE) {
                return new JqlAndClauseImpl(node);
            }
            if (type == NOT_CLAUSE) {
                return new JqlNotClauseImpl(node);
            }
            if (type == SUB_CLAUSE) {
                return new JqlSubClauseImpl(node);
            }
            if (type == SIMPLE_CLAUSE) {
                return new JqlSimpleClauseImpl(node);
            }
            if (type == WAS_CLAUSE) {
                return new JqlWasClauseImpl(node);
            }
            if (type == CHANGED_CLAUSE) {
                return new JqlChangedClauseImpl(node);
            }
            if (type == LIST) {
                return new JqlListImpl(node);
            }
            if (type == ORDER_BY) {
                return new JqlOrderByImpl(node);
            }
            if (type == IDENTIFIER) {
                return new JqlIdentifierImpl(node);
            }
            if (type == LITERAL) {
                return new JqlLiteralImpl(node);
            }
            if (type == FUNCTION_CALL) {
                return new JqlFunctionCallImpl(node);
            }
            if (type == ARGUMENT_LIST) {
                return new JqlArgumentListImpl(node);
            }
            if (type == SORT_KEY) {
                return new JqlSortKeyImpl(node);
            }
            if (type == EMPTY) {
                return new JqlEmptyValueImpl(node);
            }
            if (type == HISTORY_PREDICATE) {
                return new JqlHistoryPredicateImpl(node);
            }
            return new ASTWrapperPsiElement(node);
        }
    }
}

