/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.JBTerminalStarter;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalSettingsListener;

public class JBTerminalPanel
extends TerminalPanel
implements FocusListener,
TerminalSettingsListener,
Disposable,
IdeEventQueue.EventDispatcher {
    private static final String[] ACTIONS_TO_SKIP = new String[]{"ActivateTerminalToolWindow", "ActivateMessagesToolWindow", "ActivateFavoritesToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateChangesToolWindow", "ShowBookmarks", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "ShowSettings"};
    private final JBTerminalSystemSettingsProvider mySettingsProvider;
    private List<AnAction> myActionsToSkip;

    public JBTerminalPanel(JBTerminalSystemSettingsProvider settingsProvider, TerminalTextBuffer backBuffer, StyleState styleState) {
        super((SettingsProvider)settingsProvider, backBuffer, styleState);
        this.mySettingsProvider = settingsProvider;
        JBTabbedTerminalWidget.convertActions((JComponent)((Object)this), this.getActions(), new Predicate<KeyEvent>(){

            public boolean apply(KeyEvent input) {
                JBTerminalPanel.this.handleKeyEvent(input);
                return true;
            }
        });
        JBTerminalPanel.registerKeymapActions(this);
        this.addFocusListener(this);
        this.mySettingsProvider.addListener(this);
    }

    private static void registerKeymapActions(final TerminalPanel terminalPanel) {
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : ACTIONS_TO_SKIP) {
            final AnAction action = actionManager.getAction(actionId);
            if (action == null) continue;
            DumbAwareAction a = new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (e.getInputEvent() instanceof KeyEvent) {
                        AnActionEvent event = new AnActionEvent(e.getInputEvent(), e.getDataContext(), e.getPlace(), new Presentation(), e.getActionManager(), e.getModifiers());
                        action.update(event);
                        if (event.getPresentation().isEnabled()) {
                            action.actionPerformed(event);
                        } else {
                            terminalPanel.handleKeyEvent((KeyEvent)event.getInputEvent());
                        }
                        event.getInputEvent().consume();
                    }
                }
            };
            for (Shortcut sc : action.getShortcutSet().getShortcuts()) {
                if (!sc.isKeyboard() || !(sc instanceof KeyboardShortcut)) continue;
                KeyboardShortcut ksc = (KeyboardShortcut)sc;
                a.registerCustomShortcutSet(ksc.getFirstKeyStroke().getKeyCode(), ksc.getFirstKeyStroke().getModifiers(), (JComponent)terminalPanel);
            }
        }
    }

    public boolean dispatch(AWTEvent e) {
        if (e instanceof KeyEvent && !this.skipKeyEvent((KeyEvent)e)) {
            this.dispatchEvent(e);
            return true;
        }
        return false;
    }

    private boolean skipKeyEvent(KeyEvent e) {
        if (this.myActionsToSkip == null) {
            return false;
        }
        int kc = e.getKeyCode();
        return kc == 27 || JBTerminalPanel.skipAction(e, this.myActionsToSkip);
    }

    private static boolean skipAction(KeyEvent e, List<AnAction> actionsToSkip) {
        if (actionsToSkip != null) {
            KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
            for (AnAction action : actionsToSkip) {
                for (Shortcut sc : action.getShortcutSet().getShortcuts()) {
                    if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void setupAntialiasing(Graphics graphics) {
        UIUtil.setupComposite((Graphics2D)((Graphics2D)graphics));
        UISettings.setupAntialiasing((Graphics)graphics);
    }

    protected void setCopyContents(StringSelection selection) {
        CopyPasteManager.getInstance().setContents((Transferable)selection);
    }

    protected void drawImage(Graphics2D gfx, BufferedImage image, int x, int y, ImageObserver observer) {
        UIUtil.drawImage((Graphics)gfx, (Image)image, (int)x, (int)y, (ImageObserver)observer);
    }

    protected void drawImage(Graphics2D g, BufferedImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        JBTerminalPanel.drawImage(g, image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public static void drawImage(Graphics g, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(0, 0, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 2 * dx1, 2 * dy1, 2 * dx2, 2 * dy2, sx1 * 2, sy1 * 2, sx2 * 2, sy2 * 2, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else if (RetinaImage.isAppleHiDPIScaledImage((Image)image)) {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1 * 2, sy1 * 2, sx2 * 2, sy2 * 2, observer);
        } else {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
    }

    protected boolean isRetina() {
        return UIUtil.isRetina();
    }

    protected String getClipboardContent() throws IOException, UnsupportedFlavorException {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        return UIUtil.createImage((int)width, (int)height, (int)2);
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.installKeyDispatcher();
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
    }

    private void installKeyDispatcher() {
        if (TerminalOptionsProvider.getInstance().overrideIdeShortcuts()) {
            this.myActionsToSkip = JBTerminalPanel.setupActionsToSkip();
            IdeEventQueue.getInstance().addDispatcher((IdeEventQueue.EventDispatcher)this, (Disposable)this);
        } else {
            this.myActionsToSkip = null;
        }
    }

    private static List<AnAction> setupActionsToSkip() {
        ArrayList res = Lists.newArrayList();
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : ACTIONS_TO_SKIP) {
            AnAction action = actionManager.getAction(actionId);
            if (action == null) continue;
            res.add(action);
        }
        return res;
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.myActionsToSkip != null) {
            this.myActionsToSkip = null;
            IdeEventQueue.getInstance().removeDispatcher((IdeEventQueue.EventDispatcher)this);
        }
        JBTerminalStarter.refreshAfterExecution();
    }

    protected Font getFontToDisplay(char c, TextStyle style) {
        FontInfo fontInfo = this.fontForChar(c, style.hasOption(TextStyle.Option.BOLD) ? 1 : 0);
        return fontInfo.getFont();
    }

    public FontInfo fontForChar(char c, @JdkConstants.FontStyle int style) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay((char)c, (int)style, (FontPreferences)this.mySettingsProvider.getColorScheme().getConsoleFontPreferences());
    }

    @Override
    public void fontChanged() {
        this.reinitFontAndResize();
    }

    public void dispose() {
        this.mySettingsProvider.removeListener(this);
    }
}

