/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import git4idea.GitPlatformFacade;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.stash.GitStashUtils;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import git4idea.util.UntrackedFilesNotifier;
import git4idea.validators.GitBranchNameValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GitUnstashDialog
extends DialogWrapper {
    private JComboBox myGitRootComboBox;
    private JLabel myCurrentBranch;
    private JButton myViewButton;
    private JButton myDropButton;
    private JButton myClearButton;
    private JCheckBox myPopStashCheckBox;
    private JTextField myBranchTextField;
    private JPanel myPanel;
    private JList myStashList;
    private JCheckBox myReinstateIndexCheckBox;
    private final HashSet<String> myBranches;
    private final Project myProject;
    private GitVcs myVcs;
    private static final Logger LOG = Logger.getInstance(GitUnstashDialog.class);

    public GitUnstashDialog(final Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myBranches = new HashSet();
        this.setModal(false);
        this.myProject = project;
        this.myVcs = GitVcs.getInstance(project);
        this.setTitle(GitBundle.getString("unstash.title"));
        this.setOKButtonText(GitBundle.getString("unstash.button.apply"));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranch);
        this.myStashList.setModel(new DefaultListModel());
        this.refreshStashList();
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.refreshStashList();
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myStashList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myBranchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myPopStashCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == Messages.showYesNoDialog((Component)GitUnstashDialog.this.getContentPane(), (String)GitBundle.message("git.unstash.clear.confirmation.message", new Object[0]), (String)GitBundle.message("git.unstash.clear.confirmation.title", new Object[0]), (Icon)Messages.getWarningIcon())) {
                    GitLineHandler h = new GitLineHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                    h.addParameters("clear");
                    GitHandlerUtil.doSynchronously(h, GitBundle.getString("unstash.clearing.stashes"), h.printableCommandLine());
                    GitUnstashDialog.this.refreshStashList();
                    GitUnstashDialog.this.updateDialogState();
                }
            }
        });
        this.myDropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final StashInfo stash = GitUnstashDialog.this.getSelectedStash();
                if (0 == Messages.showYesNoDialog((Component)GitUnstashDialog.this.getContentPane(), (String)GitBundle.message("git.unstash.drop.confirmation.message", stash.getStash(), stash.getMessage()), (String)GitBundle.message("git.unstash.drop.confirmation.title", stash.getStash()), (Icon)Messages.getQuestionIcon())) {
                    final ModalityState current = ModalityState.current();
                    ProgressManager.getInstance().run((Task)new Task.Modal(GitUnstashDialog.this.myProject, "Removing stash " + stash.getStash(), false){

                        public void run(ProgressIndicator indicator) {
                            final GitSimpleHandler h = this.dropHandler(stash.getStash());
                            try {
                                h.run();
                                h.unsilence();
                            }
                            catch (VcsException ex) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GitUIUtil.showOperationError(myProject, ex, h.printableCommandLine());
                                    }
                                }, current);
                            }
                        }
                    });
                    GitUnstashDialog.this.refreshStashList();
                    GitUnstashDialog.this.updateDialogState();
                }
            }

            private GitSimpleHandler dropHandler(String stash) {
                GitSimpleHandler h = new GitSimpleHandler(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getGitRoot(), GitCommand.STASH);
                h.addParameters("drop");
                GitUnstashDialog.this.addStashParameter(h, stash);
                return h;
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String resolvedStash;
                VirtualFile root = GitUnstashDialog.this.getGitRoot();
                String selectedStash = GitUnstashDialog.this.getSelectedStash().getStash();
                try {
                    GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.REV_LIST);
                    h.setSilent(true);
                    h.addParameters("--timestamp", "--max-count=1");
                    GitUnstashDialog.this.addStashParameter(h, selectedStash);
                    h.endOptions();
                    String output = h.run();
                    resolvedStash = GitRevisionNumber.parseRevlistOutputAsRevisionNumber(h, output).asString();
                }
                catch (VcsException ex) {
                    GitUIUtil.showOperationError(GitUnstashDialog.this.myProject, ex, "resolving revision");
                    return;
                }
                GitUtil.showSubmittedFiles(GitUnstashDialog.this.myProject, resolvedStash, root, true, false);
            }
        });
        this.init();
        this.updateDialogState();
    }

    private void addStashParameter(GitHandler handler, String stash) {
        if (GitVersionSpecialty.NEEDS_QUOTES_IN_STASH_NAME.existsIn(this.myVcs.getVersion())) {
            handler.addParameters(GeneralCommandLine.inescapableQuote((String)stash));
        } else {
            handler.addParameters(stash);
        }
    }

    private void updateDialogState() {
        String branch = this.myBranchTextField.getText();
        if (branch.length() != 0) {
            this.setOKButtonText(GitBundle.getString("unstash.button.branch"));
            this.myPopStashCheckBox.setEnabled(false);
            this.myPopStashCheckBox.setSelected(true);
            this.myReinstateIndexCheckBox.setEnabled(false);
            this.myReinstateIndexCheckBox.setSelected(true);
            if (!GitBranchNameValidator.INSTANCE.checkInput(branch)) {
                this.setErrorText(GitBundle.getString("unstash.error.invalid.branch.name"));
                this.setOKActionEnabled(false);
                return;
            }
            if (this.myBranches.contains(branch)) {
                this.setErrorText(GitBundle.getString("unstash.error.branch.exists"));
                this.setOKActionEnabled(false);
                return;
            }
        } else {
            if (!this.myPopStashCheckBox.isEnabled()) {
                this.myPopStashCheckBox.setSelected(false);
            }
            this.myPopStashCheckBox.setEnabled(true);
            this.setOKButtonText(this.myPopStashCheckBox.isSelected() ? GitBundle.getString("unstash.button.pop") : GitBundle.getString("unstash.button.apply"));
            if (!this.myReinstateIndexCheckBox.isEnabled()) {
                this.myReinstateIndexCheckBox.setSelected(false);
            }
            this.myReinstateIndexCheckBox.setEnabled(true);
        }
        if (this.myStashList.getModel().getSize() == 0) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.myClearButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myClearButton.setEnabled(true);
        if (this.myStashList.getSelectedIndex() == -1) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myViewButton.setEnabled(true);
        this.myDropButton.setEnabled(true);
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void refreshStashList() {
        final DefaultListModel listModel = (DefaultListModel)this.myStashList.getModel();
        listModel.clear();
        VirtualFile root = this.getGitRoot();
        GitStashUtils.loadStashStack(this.myProject, root, new Consumer<StashInfo>(){

            public void consume(StashInfo stashInfo) {
                listModel.addElement(stashInfo);
            }
        });
        this.myBranches.clear();
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
        if (repository != null) {
            this.myBranches.addAll(GitBranchUtil.convertBranchesToNames(repository.getBranches().getLocalBranches()));
        } else {
            LOG.error("Repository is null for root " + root);
        }
        this.myStashList.setSelectedIndex(0);
    }

    private VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    private GitLineHandler handler() {
        GitLineHandler h = new GitLineHandler(this.myProject, this.getGitRoot(), GitCommand.STASH);
        String branch = this.myBranchTextField.getText();
        if (branch.length() == 0) {
            h.addParameters(this.myPopStashCheckBox.isSelected() ? "pop" : "apply");
            if (this.myReinstateIndexCheckBox.isSelected()) {
                h.addParameters("--index");
            }
        } else {
            h.addParameters("branch", branch);
        }
        String selectedStash = this.getSelectedStash().getStash();
        this.addStashParameter(h, selectedStash);
        return h;
    }

    private StashInfo getSelectedStash() {
        return (StashInfo)this.myStashList.getSelectedValue();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Unstash";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStashList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOKAction() {
        VirtualFile root = this.getGitRoot();
        final GitLineHandler h = this.handler();
        final AtomicBoolean conflict = new AtomicBoolean();
        h.addLineListener(new GitLineHandlerAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (line.contains("Merge conflict")) {
                    conflict.set(true);
                }
            }
        });
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
        GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
        h.addLineListener(untrackedFilesDetector);
        h.addLineListener(localChangesDetector);
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            final Ref result = Ref.create();
            ProgressManager.getInstance().run((Task)new Task.Modal(h.project(), GitBundle.getString("unstash.unstashing"), false){

                public void run(ProgressIndicator indicator) {
                    indicator.setIndeterminate(true);
                    h.addLineListener(new GitHandlerUtil.GitLineHandlerListenerProgress(indicator, h, "stash", false));
                    Git git = (Git)ServiceManager.getService(Git.class);
                    result.set((Object)git.runCommand((Computable<GitLineHandler>)new Computable.PredefinedValueComputable((Object)h)));
                }
            });
            ((GitPlatformFacade)ServiceManager.getService((Project)this.myProject, GitPlatformFacade.class)).hardRefresh(root);
            GitCommandResult res = (GitCommandResult)result.get();
            if (conflict.get()) {
                boolean conflictsResolved = new UnstashConflictResolver(this.myProject, root, this.getSelectedStash()).merge();
                LOG.info("loadRoot " + root + ", conflictsResolved: " + conflictsResolved);
            } else if (untrackedFilesDetector.wasMessageDetected()) {
                UntrackedFilesNotifier.notifyUntrackedFilesOverwrittenBy(this.myProject, root, untrackedFilesDetector.getRelativeFilePaths(), "unstash", null);
            } else if (localChangesDetector.wasMessageDetected()) {
                LocalChangesWouldBeOverwrittenHelper.showErrorDialog(this.myProject, root, "unstash", localChangesDetector.getRelativeFilePaths());
            } else if (!res.success()) {
                GitUIUtil.showOperationErrors(this.myProject, h.errors(), h.printableCommandLine());
            }
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
        super.doOKAction();
    }

    public static void showUnstashDialog(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot) {
        new GitUnstashDialog(project, gitRoots, defaultRoot).show();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRootComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jLabel.setText("  ");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.stashes"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myViewButton = jButton3 = new JButton();
        jButton3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.view.tooltip"));
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.view"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDropButton = jButton2 = new JButton();
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.drop.tooltip"));
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.drop"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myClearButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.clear.tooltip"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.clear"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.branch.label:"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchTextField = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.branch.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myStashList = jBList;
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPopStashCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.pop.stash"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.pop.stash.tooltip"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReinstateIndexCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.reinstate.index"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("unstash.reinstate.index.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor((Component)jBScrollPane);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private final StashInfo myStashInfo;

        public UnstashMergeDialogCustomizer(StashInfo stashInfo) {
            this.myStashInfo = stashInfo;
        }

        public String getMultipleFileMergeDescription(Collection<VirtualFile> files) {
            return "<html>Conflicts during unstashing <code>" + this.myStashInfo.getStash() + "\"" + this.myStashInfo.getMessage() + "\"</code></html>";
        }

        public String getLeftPanelTitle(VirtualFile file) {
            return "Local changes";
        }

        public String getRightPanelTitle(VirtualFile file, VcsRevisionNumber lastRevisionNumber) {
            return "Changes from stash";
        }
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final VirtualFile myRoot;
        private final StashInfo myStashInfo;

        public UnstashConflictResolver(Project project, VirtualFile root, StashInfo stashInfo) {
            super(project, (Git)ServiceManager.getService(Git.class), (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class), Collections.singleton(root), UnstashConflictResolver.makeParams(stashInfo));
            this.myRoot = root;
            this.myStashInfo = stashInfo;
        }

        private static GitConflictResolver.Params makeParams(StashInfo stashInfo) {
            GitConflictResolver.Params params = new GitConflictResolver.Params();
            params.setErrorNotificationTitle("Unstashed with conflicts");
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer(stashInfo));
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Conflicts were not resolved during unstash", "Unstash is not complete, you have unresolved merges in your working tree<br/><a href='resolve'>Resolve</a> conflicts.", new NotificationListener(){

                public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                        new UnstashConflictResolver(UnstashConflictResolver.this.myProject, UnstashConflictResolver.this.myRoot, UnstashConflictResolver.this.myStashInfo).mergeNoProceed();
                    }
                }
            });
        }
    }
}

