/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.util.Consumer;
import git4idea.GitCommit;
import git4idea.ui.GitCommitListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GitCommitListWithDiffPanel
extends JPanel {
    private final ChangesBrowser myChangesBrowser;
    private final GitCommitListPanel myCommitListPanel;

    public GitCommitListWithDiffPanel(Project project, List<GitCommit> commits) {
        super(new BorderLayout());
        this.myCommitListPanel = new GitCommitListPanel(commits, null);
        this.myCommitListPanel.addListMultipleSelectionListener(new Consumer<List<Change>>(){

            public void consume(List<Change> changes) {
                GitCommitListWithDiffPanel.this.myChangesBrowser.setChangesToDisplay(changes);
            }
        });
        this.myChangesBrowser = new ChangesBrowser(project, null, Collections.emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myCommitListPanel.registerDiffAction((AnAction)this.myChangesBrowser.getDiffAction());
        Splitter splitter = new Splitter(false, 0.7f);
        splitter.setHonorComponentsMinimumSize(false);
        splitter.setFirstComponent((JComponent)this.myCommitListPanel);
        splitter.setSecondComponent((JComponent)this.myChangesBrowser);
        this.add((Component)splitter);
    }

    public JComponent getPreferredFocusComponent() {
        return this.myCommitListPanel.getPreferredFocusComponent();
    }

    public void setCommits(List<GitCommit> commits) {
        this.myCommitListPanel.setCommits(commits);
    }
}

