/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.status.GitChangesCollector;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

class GitOldChangesCollector
extends GitChangesCollector {
    private final List<VirtualFile> myUnversioned = new ArrayList<VirtualFile>();
    private final Set<String> myUnmergedNames = new HashSet<String>();
    private final List<Change> myChanges = new ArrayList<Change>();

    static GitOldChangesCollector collect(Project project, ChangeListManager changeListManager, ProjectLevelVcsManager vcsManager, AbstractVcs vcs, VcsDirtyScope dirtyScope, VirtualFile vcsRoot) throws VcsException {
        return new GitOldChangesCollector(project, changeListManager, vcsManager, vcs, dirtyScope, vcsRoot);
    }

    @Override
    Collection<VirtualFile> getUnversionedFiles() {
        return this.myUnversioned;
    }

    @Override
    Collection<Change> getChanges() {
        return this.myChanges;
    }

    private GitOldChangesCollector(Project project, ChangeListManager changeListManager, ProjectLevelVcsManager vcsManager, AbstractVcs vcs, VcsDirtyScope dirtyScope, VirtualFile vcsRoot) throws VcsException {
        super(project, changeListManager, vcsManager, vcs, dirtyScope, vcsRoot);
        this.updateIndex();
        this.collectUnmergedAndUnversioned();
        this.collectDiffChanges();
    }

    private void updateIndex() throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.UPDATE_INDEX);
        handler.addParameters("--refresh", "--ignore-missing");
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        handler.ignoreErrorCode(1);
        handler.run();
    }

    private void collectDiffChanges() throws VcsException {
        block5: {
            Collection<FilePath> dirtyPaths = this.dirtyPaths(true);
            if (dirtyPaths.isEmpty()) {
                return;
            }
            try {
                String output = GitChangeUtils.getDiffOutput(this.myProject, this.myVcsRoot, "HEAD", dirtyPaths);
                GitChangeUtils.parseChanges(this.myProject, this.myVcsRoot, null, GitChangeUtils.resolveReference(this.myProject, this.myVcsRoot, "HEAD"), output, this.myChanges, this.myUnmergedNames);
            }
            catch (VcsException ex) {
                if (!GitChangeUtils.isHeadMissing(ex)) {
                    throw ex;
                }
                GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
                handler.addParameters("--cached");
                handler.setSilent(true);
                handler.setStdoutSuppressed(true);
                String output = handler.run();
                if (output.length() <= 0) break block5;
                StringTokenizer tokenizer = new StringTokenizer(output, "\n\r");
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    Change ch = new Change(null, GitContentRevision.createRevision(this.myVcsRoot, s, null, this.myProject, false, false, true), FileStatus.ADDED);
                    this.myChanges.add(ch);
                }
            }
        }
    }

    private void collectUnmergedAndUnversioned() throws VcsException {
        Collection<FilePath> dirtyPaths = this.dirtyPaths(false);
        if (dirtyPaths.isEmpty()) {
            return;
        }
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
        handler.addParameters("-v", "--unmerged");
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        this.parseFiles(handler.run());
        handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
        handler.addParameters("-v", "--others", "--exclude-standard");
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        handler.endOptions();
        handler.addRelativePaths(dirtyPaths);
        if (handler.isLargeCommandLine()) {
            handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
            handler.addParameters("-v", "--others", "--exclude-standard");
            handler.setSilent(true);
            handler.setStdoutSuppressed(true);
            handler.endOptions();
        }
        this.parseFiles(handler.run());
    }

    private void parseFiles(String list) throws VcsException {
        StringScanner sc = new StringScanner(list);
        while (sc.hasMoreData()) {
            Object file;
            if (sc.isEol()) {
                sc.nextLine();
                continue;
            }
            char status = sc.peek();
            sc.skipChars(2);
            if ('?' == status) {
                file = this.myVcsRoot.findFileByRelativePath(GitUtil.unescapePath(sc.line()));
                if (!Comparing.equal((Object)GitUtil.gitRootOrNull(file), (Object)this.myVcsRoot)) continue;
                this.myUnversioned.add((VirtualFile)file);
                continue;
            }
            if ('M' == status) {
                sc.boundedToken('\t');
                file = GitUtil.unescapePath(sc.line());
                VirtualFile vFile = this.myVcsRoot.findFileByRelativePath((String)file);
                if (!Comparing.equal((Object)GitUtil.gitRootOrNull(vFile), (Object)this.myVcsRoot) || !this.myUnmergedNames.add((String)file)) continue;
                ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, (String)file, (VcsRevisionNumber)new GitRevisionNumber("orig_head"), this.myProject, false, true, true);
                ContentRevision after = GitContentRevision.createRevision(this.myVcsRoot, (String)file, null, this.myProject, false, false, true);
                this.myChanges.add(new Change(before, after, FileStatus.MERGED_WITH_CONFLICTS));
                continue;
            }
            throw new VcsException("Unsupported type of the merge conflict detected: " + status);
        }
    }
}

