/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.Convertor;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.status.GitChangesCollector;
import git4idea.status.GitNewChangesCollector;
import git4idea.status.GitOldChangesCollector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GitChangeProvider
implements ChangeProvider {
    private static final Logger PROFILE_LOG = Logger.getInstance((String)"#GitStatus");
    private final Project myProject;
    private final Git myGit;
    private final ChangeListManager myChangeListManager;
    private final FileDocumentManager myFileDocumentManager;
    private final ProjectLevelVcsManager myVcsManager;

    public GitChangeProvider(Project project, Git git, ChangeListManager changeListManager, FileDocumentManager fileDocumentManager, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myGit = git;
        this.myChangeListManager = changeListManager;
        this.myFileDocumentManager = fileDocumentManager;
        this.myVcsManager = vcsManager;
    }

    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        GitChangeProvider.appendNestedVcsRootsToDirt(dirtyScope, vcs, this.myVcsManager);
        Collection affected = dirtyScope.getAffectedContentRoots();
        Set<VirtualFile> roots = GitUtil.gitRootsForPaths(affected);
        try {
            MyNonChangedHolder holder = new MyNonChangedHolder(this.myProject, dirtyScope.getDirtyFilesNoExpand(), addGate, this.myFileDocumentManager, this.myVcsManager);
            for (VirtualFile root : roots) {
                GitChangeProvider.debug("checking root: " + root.getPath());
                GitOldChangesCollector collector = this.isNewGitChangeProviderAvailable() ? GitNewChangesCollector.collect(this.myProject, this.myGit, this.myChangeListManager, this.myVcsManager, vcs, dirtyScope, root) : GitOldChangesCollector.collect(this.myProject, this.myChangeListManager, this.myVcsManager, vcs, dirtyScope, root);
                Collection<Change> changes = ((GitChangesCollector)collector).getChanges();
                holder.changed(changes);
                for (Change file : changes) {
                    GitChangeProvider.debug("process change: " + ChangesUtil.getFilePath((Change)file).getPath());
                    builder.processChange(file, GitVcs.getKey());
                }
                for (VirtualFile f : ((GitChangesCollector)collector).getUnversionedFiles()) {
                    builder.processUnversionedFile(f);
                    holder.unversioned(f);
                }
                holder.feedBuilder(builder);
            }
        }
        catch (VcsException e) {
            PROFILE_LOG.info((Throwable)e);
            vcs.getExecutableValidator().showNotificationOrThrow(e);
        }
    }

    public static void appendNestedVcsRootsToDirt(final VcsDirtyScope dirtyScope, GitVcs vcs, ProjectLevelVcsManager vcsManager) {
        Set recursivelyDirtyDirectories = dirtyScope.getRecursivelyDirtyDirectories();
        if (recursivelyDirtyDirectories.isEmpty()) {
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        HashSet<VirtualFile> rootsUnderGit = new HashSet<VirtualFile>(Arrays.asList(vcsManager.getRootsUnderVcs((AbstractVcs)vcs)));
        HashSet<VirtualFile> inputColl = new HashSet<VirtualFile>(rootsUnderGit);
        final HashSet<VirtualFile> existingInScope = new HashSet<VirtualFile>();
        for (FilePath dir : recursivelyDirtyDirectories) {
            VirtualFile vf = dir.getVirtualFile();
            if (vf == null) {
                vf = lfs.findFileByIoFile(dir.getIOFile());
            }
            if (vf == null) {
                vf = lfs.refreshAndFindFileByIoFile(dir.getIOFile());
            }
            if (vf == null) continue;
            existingInScope.add(vf);
        }
        inputColl.addAll(existingInScope);
        FileUtil.removeAncestors(inputColl, (Convertor)new Convertor<VirtualFile, String>(){

            public String convert(VirtualFile o) {
                return o.getPath();
            }
        }, (PairProcessor)new PairProcessor<VirtualFile, VirtualFile>(){

            public boolean process(VirtualFile parent, VirtualFile child) {
                if (!existingInScope.contains(child) && existingInScope.contains(parent)) {
                    GitChangeProvider.debug("adding git root for check: " + child.getPath());
                    ((VcsModifiableDirtyScope)dirtyScope).addDirtyDirRecursively((FilePath)new FilePathImpl(child));
                }
                return true;
            }
        });
    }

    private boolean isNewGitChangeProviderAvailable() {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (vcs == null) {
            return false;
        }
        GitVersion version = vcs.getVersion();
        return GitVersionSpecialty.KNOWS_STATUS_PORCELAIN.existsIn(version);
    }

    public static void debug(String message) {
        PROFILE_LOG.debug(message);
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    private static class MyNonChangedHolder {
        private final Project myProject;
        private final Set<FilePath> myDirty;
        private final ChangeListManagerGate myAddGate;
        private FileDocumentManager myFileDocumentManager;
        private ProjectLevelVcsManager myVcsManager;

        private MyNonChangedHolder(Project project, Set<FilePath> dirty, ChangeListManagerGate addGate, FileDocumentManager fileDocumentManager, ProjectLevelVcsManager vcsManager) {
            this.myProject = project;
            this.myDirty = dirty;
            this.myAddGate = addGate;
            this.myFileDocumentManager = fileDocumentManager;
            this.myVcsManager = vcsManager;
        }

        public void changed(Collection<Change> changes) {
            for (Change change : changes) {
                FilePath afterPath;
                FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
                if (beforePath != null) {
                    this.myDirty.remove(beforePath);
                }
                if ((afterPath = ChangesUtil.getBeforePath((Change)change)) == null) continue;
                this.myDirty.remove(afterPath);
            }
        }

        public void unversioned(VirtualFile vf) {
            this.myDirty.remove(new FilePathImpl(vf));
        }

        public void feedBuilder(ChangelistBuilder builder) throws VcsException {
            VcsKey gitKey = GitVcs.getKey();
            for (FilePath filePath : this.myDirty) {
                VirtualFile root;
                VirtualFile vf = filePath.getVirtualFile();
                if (vf == null || this.myAddGate.getStatus(vf) != null || !this.myFileDocumentManager.isFileModified(vf) || (root = this.myVcsManager.getVcsRootFor(vf)) == null) continue;
                GitRevisionNumber beforeRevisionNumber = GitChangeUtils.resolveReference(this.myProject, root, "HEAD");
                builder.processChange(new Change(GitContentRevision.createRevision(vf, (VcsRevisionNumber)beforeRevisionNumber, this.myProject), GitContentRevision.createRevision(vf, null, this.myProject), FileStatus.MODIFIED), gitKey);
            }
        }
    }
}

