/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.messages.MessageBusConnection;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GitUntrackedFilesHolder
implements Disposable,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final GitRepositoryFiles myRepositoryFiles;
    private final Git myGit;
    private final Set<VirtualFile> myDefinitelyUntrackedFiles = new HashSet<VirtualFile>();
    private final Set<VirtualFile> myPossiblyUntrackedFiles = new HashSet<VirtualFile>();
    private boolean myReady;
    private final Object LOCK = new Object();
    private final GitRepositoryManager myRepositoryManager;

    GitUntrackedFilesHolder(GitRepository repository) {
        this.myProject = repository.getProject();
        this.myRoot = repository.getRoot();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(repository.getGitDir());
    }

    void setupVfsListener(Project project) {
        if (!project.isDisposed()) {
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
            connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myDefinitelyUntrackedFiles;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(VirtualFile file) {
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<VirtualFile> files) {
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection<VirtualFile> files) {
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.removeAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        if (this.isReady()) {
            this.verifyPossiblyUntrackedFiles();
        } else {
            this.rescanAll();
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            return new ArrayList<VirtualFile>(this.myDefinitelyUntrackedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAll() throws VcsException {
        Set<VirtualFile> untrackedFiles = this.myGit.untrackedFiles(this.myProject, this.myRoot, null);
        Object object = this.myDefinitelyUntrackedFiles;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
            this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.clear();
            this.myReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReady() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myReady;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyPossiblyUntrackedFiles() throws VcsException {
        HashSet<VirtualFile> suspiciousFiles = new HashSet<VirtualFile>();
        Set<VirtualFile> set = this.LOCK;
        synchronized (set) {
            suspiciousFiles.addAll(this.myPossiblyUntrackedFiles);
            this.myPossiblyUntrackedFiles.clear();
        }
        set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            Set<VirtualFile> untrackedFiles = this.myGit.untrackedFiles(this.myProject, this.myRoot, suspiciousFiles);
            suspiciousFiles.removeAll(untrackedFiles);
            HashSet<VirtualFile> trackedFiles = suspiciousFiles;
            this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
            this.myDefinitelyUntrackedFiles.removeAll(trackedFiles);
        }
    }

    public void before(List<? extends VFileEvent> events) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(List<? extends VFileEvent> events) {
        Object object;
        boolean allChanged = false;
        HashSet<VirtualFile> filesToRefresh = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            if (allChanged) break;
            String path = vFileEvent.getPath();
            if (this.totalRefreshNeeded(path)) {
                allChanged = true;
                continue;
            }
            VirtualFile affectedFile = GitUntrackedFilesHolder.getAffectedFile(vFileEvent);
            if (!this.notIgnored(affectedFile)) continue;
            filesToRefresh.add(affectedFile);
        }
        if (allChanged) {
            LOG.debug(String.format("GitUntrackedFilesHolder: Index has changed, marking %s recursively dirty", this.myRoot));
            this.myDirtyScopeManager.dirDirtyRecursively(this.myRoot);
            object = this.LOCK;
            synchronized (object) {
                this.myReady = false;
            }
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.addAll(filesToRefresh);
        }
    }

    private boolean totalRefreshNeeded(String path) {
        return this.indexChanged(path) || this.externallyCommitted(path) || this.gitignoreChanged(path);
    }

    private boolean indexChanged(String path) {
        return this.myRepositoryFiles.isIndexFile(path);
    }

    private boolean externallyCommitted(String path) {
        return this.myRepositoryFiles.isCommitMessageFile(path);
    }

    private boolean gitignoreChanged(String path) {
        return path.endsWith(".gitignore") || this.myRepositoryFiles.isExclude(path);
    }

    private static VirtualFile getAffectedFile(VFileEvent event) {
        if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent) {
            return event.getFile();
        }
        if (event instanceof VFileCopyEvent) {
            VFileCopyEvent copyEvent = (VFileCopyEvent)event;
            return copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
        }
        return null;
    }

    private boolean notIgnored(VirtualFile file) {
        return file != null && this.belongsToThisRepository(file) && !this.myChangeListManager.isIgnoredFile(file);
    }

    private boolean belongsToThisRepository(VirtualFile file) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForFile(file);
        return repository != null && repository.getRoot().equals(this.myRoot);
    }
}

