/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitUntrackedFilesHolder;
import java.io.File;
import java.util.Collection;

public class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    private final GitPlatformFacade myPlatformFacade;
    private final GitRepositoryReader myReader;
    private final VirtualFile myGitDir;
    private final GitUntrackedFilesHolder myUntrackedFilesHolder;
    private volatile GitRepoInfo myInfo;

    protected GitRepositoryImpl(VirtualFile rootDir, GitPlatformFacade facade, Project project, Disposable parentDisposable, boolean light) {
        super(project, rootDir, parentDisposable);
        this.myPlatformFacade = facade;
        this.myGitDir = GitUtil.findGitDir(rootDir);
        assert (this.myGitDir != null) : ".git directory wasn't found under " + rootDir.getPresentableUrl();
        this.myReader = new GitRepositoryReader(VfsUtilCore.virtualToIoFile((VirtualFile)this.myGitDir));
        if (!light) {
            this.myUntrackedFilesHolder = new GitUntrackedFilesHolder(this);
            Disposer.register((Disposable)this, (Disposable)this.myUntrackedFilesHolder);
        } else {
            this.myUntrackedFilesHolder = null;
        }
        this.update();
    }

    public static GitRepository getLightInstance(VirtualFile root, Project project, GitPlatformFacade facade, Disposable parentDisposable) {
        return new GitRepositoryImpl(root, facade, project, parentDisposable, true);
    }

    public static GitRepository getFullInstance(VirtualFile root, Project project, GitPlatformFacade facade, Disposable parentDisposable) {
        GitRepositoryImpl repository = new GitRepositoryImpl(root, facade, project, parentDisposable, false);
        repository.myUntrackedFilesHolder.setupVfsListener(project);
        repository.setupUpdater();
        return repository;
    }

    private void setupUpdater() {
        GitRepositoryUpdater updater = new GitRepositoryUpdater(this);
        Disposer.register((Disposable)this, (Disposable)updater);
    }

    @Override
    public VirtualFile getGitDir() {
        return this.myGitDir;
    }

    @Override
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        if (this.myUntrackedFilesHolder == null) {
            throw new IllegalStateException("Using untracked files holder with light git repository instance " + this);
        }
        return this.myUntrackedFilesHolder;
    }

    @Override
    public GitRepoInfo getInfo() {
        return this.myInfo;
    }

    @Override
    public GitLocalBranch getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    public Repository.State getState() {
        return this.myInfo.getState();
    }

    public String getCurrentBranchName() {
        GitLocalBranch currentBranch = this.getCurrentBranch();
        return currentBranch == null ? null : currentBranch.getName();
    }

    public AbstractVcs getVcs() {
        return GitVcs.getInstance(this.getProject());
    }

    @Override
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.myInfo;
        return new GitBranchesCollection(info.getLocalBranches(), info.getRemoteBranches());
    }

    @Override
    public Collection<GitRemote> getRemotes() {
        return this.myInfo.getRemotes();
    }

    @Override
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        return this.myInfo.getBranchTrackInfos();
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.getState() != Repository.State.DETACHED && this.getState() != Repository.State.REBASING;
    }

    public boolean isFresh() {
        return this.getCurrentRevision() == null;
    }

    public void update() {
        GitRepoInfo previousInfo = this.myInfo;
        this.myInfo = this.readRepoInfo();
        GitRepositoryImpl.notifyListeners(this, previousInfo, this.myInfo);
    }

    private GitRepoInfo readRepoInfo() {
        File configFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.getGitDir()), "config");
        GitConfig config = GitConfig.read(this.myPlatformFacade, configFile);
        Collection<GitRemote> remotes = config.parseRemotes();
        GitBranchState state = this.myReader.readState(remotes);
        Collection<GitBranchTrackInfo> trackInfos = config.parseTrackInfos(state.getLocalBranches(), state.getRemoteBranches());
        return new GitRepoInfo(state.getCurrentBranch(), state.getCurrentRevision(), state.getState(), remotes, state.getLocalBranches(), state.getRemoteBranches(), trackInfos);
    }

    private static void notifyListeners(final GitRepository repository, GitRepoInfo previousInfo, GitRepoInfo info) {
        if (Disposer.isDisposed((Disposable)repository.getProject())) {
            return;
        }
        if (!info.equals(previousInfo)) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    Project project = repository.getProject();
                    if (!project.isDisposed()) {
                        ((GitRepositoryChangeListener)project.getMessageBus().syncPublisher(GitRepository.GIT_REPO_CHANGE)).repositoryChanged(repository);
                    }
                }
            });
        }
    }

    public String toLogString() {
        return String.format("GitRepository " + this.getRoot() + " : " + this.myInfo, new Object[0]);
    }
}

