/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;

public class GitRepositoryCreator
extends VcsRepositoryCreator {
    private final Project myProject;
    private final GitPlatformFacade myPlatformFacade;

    public GitRepositoryCreator(Project project, GitPlatformFacade platformFacade) {
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
    }

    public Repository createRepositoryIfValid(VirtualFile root) {
        VirtualFile head;
        VirtualFile dotGitDir;
        if (GitUtil.isGitRoot(new File(root.getPath())) && (dotGitDir = GitUtil.findGitDir(root)) != null && dotGitDir.isDirectory() && (head = dotGitDir.findChild("HEAD")) != null && head.isValid()) {
            return GitRepositoryImpl.getFullInstance(root, this.myProject, this.myPlatformFacade, (Disposable)this.myProject);
        }
        return null;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }
}

