/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class GitConfig {
    private static final Logger LOG = Logger.getInstance(GitConfig.class);
    private static final Pattern REMOTE_SECTION = Pattern.compile("(?:svn-)?remote \"(.*)\"");
    private static final Pattern URL_SECTION = Pattern.compile("url \"(.*)\"");
    private static final Pattern BRANCH_INFO_SECTION = Pattern.compile("branch \"(.*)\"");
    private static final Pattern BRANCH_COMMON_PARAMS_SECTION = Pattern.compile("branch");
    private final Collection<Remote> myRemotes;
    private final Collection<Url> myUrls;
    private final Collection<BranchConfig> myTrackedInfos;

    private GitConfig(Collection<Remote> remotes, Collection<Url> urls, Collection<BranchConfig> trackedInfos) {
        this.myRemotes = remotes;
        this.myUrls = urls;
        this.myTrackedInfos = trackedInfos;
    }

    Collection<GitRemote> parseRemotes() {
        return ContainerUtil.map(this.myRemotes, (Function)new Function<Remote, GitRemote>(){

            public GitRemote fun(Remote remote) {
                assert (remote != null);
                return GitConfig.convertRemoteToGitRemote(GitConfig.this.myUrls, remote);
            }
        });
    }

    private static GitRemote convertRemoteToGitRemote(Collection<Url> urls, Remote remote) {
        UrlsAndPushUrls substitutedUrls = GitConfig.substituteUrls(urls, remote);
        return new GitRemote(remote.myName, substitutedUrls.getUrls(), substitutedUrls.getPushUrls(), remote.getFetchSpecs(), GitConfig.computePushSpec(remote));
    }

    Collection<GitBranchTrackInfo> parseTrackInfos(final Collection<GitLocalBranch> localBranches, final Collection<GitRemoteBranch> remoteBranches) {
        return ContainerUtil.mapNotNull(this.myTrackedInfos, (Function)new Function<BranchConfig, GitBranchTrackInfo>(){

            public GitBranchTrackInfo fun(BranchConfig config) {
                if (config != null) {
                    return GitConfig.convertBranchConfig(config, localBranches, remoteBranches);
                }
                return null;
            }
        });
    }

    static GitConfig read(GitPlatformFacade platformFacade, File configFile) {
        GitConfig emptyConfig = new GitConfig(Collections.<Remote>emptyList(), Collections.<Url>emptyList(), Collections.<BranchConfig>emptyList());
        if (!configFile.exists()) {
            LOG.info("No .git/config file at " + configFile.getPath());
            return emptyConfig;
        }
        Ini ini = new Ini();
        ini.getConfig().setMultiOption(true);
        ini.getConfig().setTree(false);
        try {
            ini.load(configFile);
        }
        catch (IOException e) {
            LOG.warn("Couldn't load .git/config file at " + configFile.getPath(), (Throwable)e);
            return emptyConfig;
        }
        IdeaPluginDescriptor plugin = platformFacade.getPluginByClassName(GitConfig.class.getName());
        ClassLoader classLoader = plugin == null ? null : plugin.getPluginClassLoader();
        Pair<Collection<Remote>, Collection<Url>> remotesAndUrls = GitConfig.parseRemotes(ini, classLoader);
        Collection<BranchConfig> trackedInfos = GitConfig.parseTrackedInfos(ini, classLoader);
        return new GitConfig((Collection)remotesAndUrls.getFirst(), (Collection)remotesAndUrls.getSecond(), trackedInfos);
    }

    private static Collection<BranchConfig> parseTrackedInfos(Ini ini, ClassLoader classLoader) {
        ArrayList<BranchConfig> configs = new ArrayList<BranchConfig>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            BranchConfig branchConfig;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (!sectionName.startsWith("branch") || (branchConfig = GitConfig.parseBranchSection(sectionName, section, classLoader)) == null) continue;
            configs.add(branchConfig);
        }
        return configs;
    }

    private static GitBranchTrackInfo convertBranchConfig(BranchConfig branchConfig, Collection<GitLocalBranch> localBranches, Collection<GitRemoteBranch> remoteBranches) {
        if (branchConfig == null) {
            return null;
        }
        String branchName = branchConfig.getName();
        String remoteName = branchConfig.getBean().getRemote();
        String mergeName = branchConfig.getBean().getMerge();
        String rebaseName = branchConfig.getBean().getRebase();
        if (StringUtil.isEmptyOrSpaces((String)mergeName) && StringUtil.isEmptyOrSpaces((String)rebaseName)) {
            LOG.info("No branch." + branchName + ".merge/rebase item in the .git/config");
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)remoteName)) {
            LOG.info("No branch." + branchName + ".remote item in the .git/config");
            return null;
        }
        boolean merge = mergeName != null;
        String remoteBranchName = StringUtil.unquoteString((String)(merge ? mergeName : rebaseName));
        GitLocalBranch localBranch = GitConfig.findLocalBranch(branchName, localBranches);
        GitRemoteBranch remoteBranch = GitConfig.findRemoteBranch(remoteBranchName, remoteName, remoteBranches);
        if (localBranch == null || remoteBranch == null) {
            LOG.debug("localBranch: " + localBranch + ", remoteBranch: " + remoteBranch);
            return null;
        }
        return new GitBranchTrackInfo(localBranch, remoteBranch, merge);
    }

    private static GitLocalBranch findLocalBranch(String branchName, Collection<GitLocalBranch> localBranches) {
        final String name = GitBranchUtil.stripRefsPrefix(branchName);
        return (GitLocalBranch)ContainerUtil.find(localBranches, (Condition)new Condition<GitLocalBranch>(){

            public boolean value(GitLocalBranch input) {
                assert (input != null);
                return input.getName().equals(name);
            }
        });
    }

    public static GitRemoteBranch findRemoteBranch(String remoteBranchName, final String remoteName, Collection<GitRemoteBranch> remoteBranches) {
        final String branchName = GitBranchUtil.stripRefsPrefix(remoteBranchName);
        return (GitRemoteBranch)ContainerUtil.find(remoteBranches, (Condition)new Condition<GitRemoteBranch>(){

            public boolean value(GitRemoteBranch branch) {
                return branch.getNameForRemoteOperations().equals(branchName) && branch.getRemote().getName().equals(remoteName);
            }
        });
    }

    private static BranchConfig parseBranchSection(String sectionName, Profile.Section section, ClassLoader classLoader) {
        BranchBean branchBean = (BranchBean)section.as(BranchBean.class, classLoader);
        Matcher matcher = BRANCH_INFO_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new BranchConfig(matcher.group(1), branchBean);
        }
        if (BRANCH_COMMON_PARAMS_SECTION.matcher(sectionName).matches()) {
            LOG.debug(String.format("Common branch option(s) defined .git/config. sectionName: %s%n section: %s", sectionName, section));
            return null;
        }
        LOG.error(String.format("Invalid branch section format in .git/config. sectionName: %s%n section: %s", sectionName, section));
        return null;
    }

    private static Pair<Collection<Remote>, Collection<Url>> parseRemotes(Ini ini, ClassLoader classLoader) {
        ArrayList<Remote> remotes = new ArrayList<Remote>();
        ArrayList<Url> urls = new ArrayList<Url>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            Url url;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (sectionName.startsWith("remote") || sectionName.startsWith("svn-remote")) {
                Remote remote = GitConfig.parseRemoteSection(sectionName, section, classLoader);
                if (remote == null) continue;
                remotes.add(remote);
                continue;
            }
            if (!sectionName.startsWith("url") || (url = GitConfig.parseUrlSection(sectionName, section, classLoader)) == null) continue;
            urls.add(url);
        }
        return Pair.create(remotes, urls);
    }

    private static List<String> computePushSpec(Remote remote) {
        List pushSpec = remote.getPushSpec();
        return pushSpec == null ? remote.getFetchSpecs() : pushSpec;
    }

    private static UrlsAndPushUrls substituteUrls(Collection<Url> urlSections, Remote remote) {
        String insteadOf;
        boolean substituted;
        ArrayList<String> urls = new ArrayList<String>(remote.getUrls().size());
        ArrayList<String> pushUrls = new ArrayList<String>();
        for (String remoteUrl : remote.getUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                String pushInsteadOf = url.getPushInsteadOf();
                if (insteadOf != null && remoteUrl.startsWith(insteadOf)) {
                    urls.add(GitConfig.substituteUrl(remoteUrl, url, insteadOf));
                    substituted = true;
                    break;
                }
                if (pushInsteadOf == null || !remoteUrl.startsWith(pushInsteadOf)) continue;
                if (remote.getPushUrls().isEmpty()) {
                    pushUrls.add(GitConfig.substituteUrl(remoteUrl, url, pushInsteadOf));
                }
                urls.add(remoteUrl);
                substituted = true;
                break;
            }
            if (substituted) continue;
            urls.add(remoteUrl);
        }
        for (String remotePushUrl : remote.getPushUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                if (insteadOf == null || !remotePushUrl.startsWith(insteadOf)) continue;
                pushUrls.add(GitConfig.substituteUrl(remotePushUrl, url, insteadOf));
                substituted = true;
                break;
            }
            if (substituted) continue;
            pushUrls.add(remotePushUrl);
        }
        if (pushUrls.isEmpty()) {
            pushUrls = new ArrayList(urls);
        }
        return new UrlsAndPushUrls(urls, pushUrls);
    }

    private static String substituteUrl(String remoteUrl, Url url, String insteadOf) {
        return url.myName + remoteUrl.substring(insteadOf.length());
    }

    private static Remote parseRemoteSection(String sectionName, Profile.Section section, ClassLoader classLoader) {
        RemoteBean remoteBean = (RemoteBean)section.as(RemoteBean.class, classLoader);
        Matcher matcher = REMOTE_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new Remote(matcher.group(1), remoteBean);
        }
        LOG.error(String.format("Invalid remote section format in .git/config. sectionName: %s section: %s", sectionName, section));
        return null;
    }

    private static Url parseUrlSection(String sectionName, Profile.Section section, ClassLoader classLoader) {
        UrlBean urlBean = (UrlBean)section.as(UrlBean.class, classLoader);
        Matcher matcher = URL_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new Url(matcher.group(1), urlBean);
        }
        LOG.error(String.format("Invalid url section format in .git/config. sectionName: %s section: %s", sectionName, section));
        return null;
    }

    private static String[] notNull(String[] s) {
        return s == null ? ArrayUtil.EMPTY_STRING_ARRAY : s;
    }

    private static Collection<String> nonNullCollection(String[] array) {
        return array == null ? Collections.emptyList() : new ArrayList<String>(Arrays.asList(array));
    }

    private static interface BranchBean {
        public String getRemote();

        public String getMerge();

        public String getRebase();
    }

    private static class BranchConfig {
        private final String myName;
        private final BranchBean myBean;

        public BranchConfig(String name, BranchBean bean) {
            this.myName = name;
            this.myBean = bean;
        }

        public String getName() {
            return this.myName;
        }

        public BranchBean getBean() {
            return this.myBean;
        }
    }

    private static interface UrlBean {
        public String getInsteadOf();

        public String getPushInsteadOf();
    }

    private static class Url {
        private final String myName;
        private final UrlBean myUrlBean;

        private Url(String name, UrlBean urlBean) {
            this.myUrlBean = urlBean;
            this.myName = name;
        }

        public String getInsteadOf() {
            return this.myUrlBean.getInsteadOf();
        }

        public String getPushInsteadOf() {
            return this.myUrlBean.getPushInsteadOf();
        }
    }

    private static interface RemoteBean {
        public String[] getFetch();

        public String[] getPush();

        public String[] getUrl();

        public String[] getPushUrl();
    }

    private static class Remote {
        private final String myName;
        private final RemoteBean myRemoteBean;

        private Remote(String name, RemoteBean remoteBean) {
            this.myRemoteBean = remoteBean;
            this.myName = name;
        }

        private Collection<String> getUrls() {
            return GitConfig.nonNullCollection(this.myRemoteBean.getUrl());
        }

        private Collection<String> getPushUrls() {
            return GitConfig.nonNullCollection(this.myRemoteBean.getPushUrl());
        }

        private List<String> getPushSpec() {
            String[] push = this.myRemoteBean.getPush();
            return push == null ? null : Arrays.asList(push);
        }

        private List<String> getFetchSpecs() {
            return Arrays.asList(GitConfig.notNull(this.myRemoteBean.getFetch()));
        }
    }

    private static class UrlsAndPushUrls {
        final List<String> myUrls;
        final Collection<String> myPushUrls;

        private UrlsAndPushUrls(List<String> urls, Collection<String> pushUrls) {
            this.myPushUrls = pushUrls;
            this.myUrls = urls;
        }

        public Collection<String> getPushUrls() {
            return this.myPushUrls;
        }

        public List<String> getUrls() {
            return this.myUrls;
        }
    }
}

