/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.util.Key;
import git4idea.commands.GitLineHandlerAdapter;
import java.util.concurrent.atomic.AtomicBoolean;

public class GitRebaseProblemDetector
extends GitLineHandlerAdapter {
    private static final String[] REBASE_CONFLICT_INDICATORS = new String[]{"Merge conflict in", "hint: after resolving the conflicts, mark the corrected paths", "Failed to merge in the changes", "could not apply"};
    private static final String REBASE_NO_CHANGE_INDICATOR = "No changes - did you forget to use 'git add'?";
    private AtomicBoolean mergeConflict = new AtomicBoolean(false);
    private AtomicBoolean noChangeError = new AtomicBoolean(false);

    public boolean isNoChangeError() {
        return this.noChangeError.get();
    }

    public boolean isMergeConflict() {
        return this.mergeConflict.get();
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        for (String conflictIndicator : REBASE_CONFLICT_INDICATORS) {
            if (!line.contains(conflictIndicator)) continue;
            this.mergeConflict.set(true);
            return;
        }
        if (line.contains(REBASE_NO_CHANGE_INDICATOR)) {
            this.noChangeError.set(true);
        }
    }
}

