/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diff.impl.dir.FrameDialogWrapper;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitVersion;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GitShowExternalLogAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && GitVcs.getInstance(e.getProject()) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final GitVcs vcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        final List<VirtualFile> roots = GitShowExternalLogAction.getGitRootsFromUser(project);
        if (roots.isEmpty()) {
            return;
        }
        if (project.isDefault() || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            ProgressManager.getInstance().run((Task)new ShowLogInDialogTask(project, roots, vcs));
            return;
        }
        final ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        Runnable showContent = new Runnable(){

            @Override
            public void run() {
                ContentManager cm = window.getContentManager();
                if (GitShowExternalLogAction.checkIfProjectLogMatches(project, vcs, cm, roots) || GitShowExternalLogAction.checkIfAlreadyOpened(cm, roots)) {
                    return;
                }
                String tabName = GitShowExternalLogAction.calcTabName(cm, roots);
                MyContentComponent component = GitShowExternalLogAction.createManagerAndContent(project, vcs, roots, tabName);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)component, tabName, false);
                content.setDisposer(component.myDisposable);
                content.setDescription("Log for " + StringUtil.join((Collection)roots, (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file) {
                        return file.getPath();
                    }
                }, (String)"\n"));
                content.setCloseable(true);
                cm.addContent(content);
                cm.setSelectedContent(content);
            }
        };
        if (!window.isVisible()) {
            window.activate(showContent, true);
        } else {
            showContent.run();
        }
    }

    private static MyContentComponent createManagerAndContent(Project project, final GitVcs vcs, final List<VirtualFile> roots, String tabName) {
        final GitRepositoryManager repositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        GitPlatformFacade facade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        for (VirtualFile root : roots) {
            repositoryManager.addExternalRepository(root, GitRepositoryImpl.getFullInstance(root, project, facade, (Disposable)project));
        }
        VcsLogManager manager = new VcsLogManager(project, (VcsLogSettings)ServiceManager.getService((Project)project, VcsLogSettings.class), (VcsLogUiProperties)ServiceManager.getService((Project)project, VcsLogUiProperties.class));
        List vcsRoots = ContainerUtil.map(roots, (Function)new Function<VirtualFile, VcsRoot>(){

            public VcsRoot fun(VirtualFile root) {
                return new VcsRoot((AbstractVcs)vcs, root);
            }
        });
        return new MyContentComponent(manager.initContent((Collection)vcsRoots, tabName), roots, new Disposable(){

            public void dispose() {
                for (VirtualFile root : roots) {
                    repositoryManager.removeExternalRepository(root);
                }
            }
        });
    }

    private static String calcTabName(ContentManager cm, List<VirtualFile> roots) {
        String name = "Log (" + roots.get(0).getName();
        if (roots.size() > 1) {
            name = name + "+";
        }
        String candidate = name = name + ")";
        int cnt = 1;
        while (GitShowExternalLogAction.hasContentsWithName(cm, candidate)) {
            candidate = name + "-" + cnt;
            ++cnt;
        }
        return candidate;
    }

    private static boolean hasContentsWithName(ContentManager cm, final String candidate) {
        return ContainerUtil.exists((Object[])cm.getContents(), (Condition)new Condition<Content>(){

            public boolean value(Content content) {
                return content.getDisplayName().equals(candidate);
            }
        });
    }

    private static List<VirtualFile> getGitRootsFromUser(Project project) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        if (virtualFiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList correctRoots = ContainerUtil.newArrayList();
        for (VirtualFile vf : virtualFiles) {
            if (!GitUtil.isGitRoot(new File(vf.getPath()))) continue;
            correctRoots.add(vf);
        }
        return correctRoots;
    }

    private static boolean checkIfProjectLogMatches(Project project, GitVcs vcs, ContentManager cm, List<VirtualFile> requestedRoots) {
        VirtualFile[] projectRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (Comparing.haveEqualElements(requestedRoots, Arrays.asList(projectRoots))) {
            Content[] contents;
            for (Content content : contents = cm.getContents()) {
                if (!"Log".equals(content.getDisplayName())) continue;
                cm.setSelectedContent(content);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfAlreadyOpened(ContentManager cm, Collection<VirtualFile> roots) {
        for (Content content : cm.getContents()) {
            JComponent component = content.getComponent();
            if (!(component instanceof MyContentComponent) || !Comparing.haveEqualElements(roots, (Collection)((MyContentComponent)component).myRoots)) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    private static class MyDialog
    extends FrameDialogWrapper {
        private final MyContentComponent myContent;
        private final Project myProject;

        private MyDialog(Project project, GitVcs vcs, List<VirtualFile> roots) {
            this.myProject = project;
            this.myContent = GitShowExternalLogAction.createManagerAndContent(project, vcs, roots, null);
        }

        protected FrameDialogWrapper.Mode getMode() {
            return FrameDialogWrapper.Mode.FRAME;
        }

        public Project getProject() {
            return this.myProject;
        }

        protected String getTitle() {
            return "Git Log";
        }

        protected JComponent getPanel() {
            return this.myContent;
        }

        protected JComponent getPreferredFocusedComponent() {
            return this.myContent;
        }

        protected Disposable getDisposable() {
            return this.myContent.myDisposable;
        }
    }

    private static class ShowLogInDialogTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final List<VirtualFile> myRoots;
        private final GitVcs myVcs;
        private GitVersion myVersion;

        private ShowLogInDialogTask(Project project, List<VirtualFile> roots, GitVcs vcs) {
            super(project, "Loading Git Log...", true, BackgroundFromStartOption.getInstance());
            this.myProject = project;
            this.myRoots = roots;
            this.myVcs = vcs;
        }

        public void run(ProgressIndicator indicator) {
            this.myVersion = this.myVcs.getVersion();
            if (this.myVersion.isNull()) {
                this.myVcs.checkVersion();
                this.myVersion = this.myVcs.getVersion();
            }
        }

        public void onSuccess() {
            if (!this.myVersion.isNull() && !this.myProject.isDisposed()) {
                new MyDialog(this.myProject, this.myVcs, this.myRoots).show();
            }
        }
    }

    private static class MyContentComponent
    extends JPanel {
        private final Collection<VirtualFile> myRoots;
        private final Disposable myDisposable;

        MyContentComponent(JComponent actualComponent, Collection<VirtualFile> roots, Disposable disposable) {
            super(new BorderLayout());
            this.myDisposable = disposable;
            this.myRoots = roots;
            this.add(actualComponent);
        }
    }
}

